/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;

public class NamespacePrefixMapperWrapper
extends NamespacePrefixMapper {
    private static String GET_PREF_PREFIX_METHOD_NAME = "getPreferredPrefix";
    private static String GET_PRE_DECL_NAMESPACE_URIS_METHOD_NAME = "getPreDeclaredNamespaceUris";
    private static String GET_PRE_DECL_NAMESPACE_URIS2_METHOD_NAME = "getPreDeclaredNamespaceUris2";
    private static String GET_CONTEXTUAL_NAMESPACE_DECL_METHOD_NAME = "getContextualNamespaceDecls";
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class[] PREF_PREFIX_PARAM_TYPES = new Class[]{String.class, String.class, ClassConstants.PBOOLEAN};
    private Object prefixMapper;
    private Method getPreferredPrefixMethod;
    private Method getPredeclaredNamespaceUrisMethod;
    private Method getPredeclaredNamespaceUris2Method;
    private Method getContextualNamespaceDeclsMethod;

    public NamespacePrefixMapperWrapper(Object prefixMapper) {
        this.prefixMapper = prefixMapper;
        Class<?> prefixMapperClass = prefixMapper.getClass();
        try {
            this.getPreferredPrefixMethod = PrivilegedAccessHelper.getMethod(prefixMapperClass, GET_PREF_PREFIX_METHOD_NAME, PREF_PREFIX_PARAM_TYPES, false);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorProcessingPrefixMapper(GET_PREF_PREFIX_METHOD_NAME, prefixMapper);
        }
        try {
            this.getPredeclaredNamespaceUrisMethod = PrivilegedAccessHelper.getMethod(prefixMapperClass, GET_PRE_DECL_NAMESPACE_URIS_METHOD_NAME, EMPTY_CLASS_ARRAY, false);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorProcessingPrefixMapper(GET_PRE_DECL_NAMESPACE_URIS_METHOD_NAME, prefixMapper);
        }
        try {
            this.getPredeclaredNamespaceUris2Method = PrivilegedAccessHelper.getMethod(prefixMapperClass, GET_PRE_DECL_NAMESPACE_URIS2_METHOD_NAME, EMPTY_CLASS_ARRAY, false);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorProcessingPrefixMapper(GET_PRE_DECL_NAMESPACE_URIS2_METHOD_NAME, prefixMapper);
        }
        try {
            this.getContextualNamespaceDeclsMethod = PrivilegedAccessHelper.getMethod(prefixMapperClass, GET_CONTEXTUAL_NAMESPACE_DECL_METHOD_NAME, EMPTY_CLASS_ARRAY, false);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorProcessingPrefixMapper(GET_CONTEXTUAL_NAMESPACE_DECL_METHOD_NAME, prefixMapper);
        }
    }

    @Override
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        try {
            return (String)PrivilegedAccessHelper.invokeMethod(this.getPreferredPrefixMethod, this.prefixMapper, new Object[]{namespaceUri, suggestion, requirePrefix});
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingPrefixMapperMethod(GET_PREF_PREFIX_METHOD_NAME, this.prefixMapper);
        }
    }

    @Override
    public String[] getContextualNamespaceDecls() {
        try {
            return (String[])PrivilegedAccessHelper.invokeMethod(this.getContextualNamespaceDeclsMethod, this.prefixMapper, new Object[0]);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingPrefixMapperMethod(GET_CONTEXTUAL_NAMESPACE_DECL_METHOD_NAME, this.prefixMapper);
        }
    }

    @Override
    public String[] getPreDeclaredNamespaceUris() {
        try {
            return (String[])PrivilegedAccessHelper.invokeMethod(this.getPredeclaredNamespaceUrisMethod, this.prefixMapper, new Object[0]);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingPrefixMapperMethod(GET_PRE_DECL_NAMESPACE_URIS_METHOD_NAME, this.prefixMapper);
        }
    }

    @Override
    public String[] getPreDeclaredNamespaceUris2() {
        try {
            return (String[])PrivilegedAccessHelper.invokeMethod(this.getPredeclaredNamespaceUris2Method, this.prefixMapper, new Object[0]);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInvokingPrefixMapperMethod(GET_PRE_DECL_NAMESPACE_URIS2_METHOD_NAME, this.prefixMapper);
        }
    }

    public Object getPrefixMapper() {
        return this.prefixMapper;
    }
}

