/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.Test;

public class ExtraSchemaNameDDLTestSuite {
    static final String CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE1 = "CREATE OR REPLACE PACKAGE EXTRA_SCHEMANAME_TEST_PACKAGE AS\nFUNCTION test(PARAM1 IN SCOTT.EMP%ROWTYPE) RETURN NUMBER;END EXTRA_SCHEMANAME_TEST_PACKAGE;";
    static final String CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE2 = "CREATE OR REPLACE PACKAGE EXTRA_SCHEMANAME_TEST_PACKAGE AS\nFUNCTION test(PARAM1 IN NUMBER) RETURN SCOTT.EMP%ROWTYPE;END EXTRA_SCHEMANAME_TEST_PACKAGE;";
    static final String CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE3 = "CREATE OR REPLACE PACKAGE SCOTT.EXTRA_SCHEMANAME_TEST_PACKAGE AS\nFUNCTION test(PARAM1 IN SCOTT.EMP%ROWTYPE) RETURN SCOTT.EMP%ROWTYPE;END EXTRA_SCHEMANAME_TEST_PACKAGE;";

    @Test
    public void testExtraSchemaNames() {
        DDLParser parser = new DDLParser(new StringReader(CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE1));
        parser.setTypesRepository(new DatabaseTypesRepository());
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"EXTRA_SCHEMANAME_TEST_PACKAGE should parse", (boolean)worked);
    }

    @Test
    public void testSetSchemaNames() {
        DDLParser parser = new DDLParser(new StringReader(CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE2));
        parser.setTypesRepository(new DatabaseTypesRepository());
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add("SCOTT");
        parser.setSchemaPatterns(schemaPatterns);
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"EXTRA_SCHEMANAME_TEST_PACKAGE should parse", (boolean)worked);
        ProcedureType procedureType = packageType.getProcedures().get(0);
        if (procedureType.isFunctionType()) {
            FunctionType functionType = (FunctionType)procedureType;
            ArgumentType returnArgument = functionType.getReturnArgument();
            DatabaseType returnArgumentDataType = returnArgument.getEnclosedType();
            String returnArgumentDataTypeName = returnArgumentDataType.getTypeName();
            Assert.assertEquals((Object)"EMP%ROWTYPE", (Object)returnArgumentDataTypeName);
        }
    }

    @Test
    public void testSameROWTYPEType() {
        DDLParser parser = new DDLParser(new StringReader(CREATE_EXTRA_SCHEMANAME_TEST_PACKAGE3));
        parser.setTypesRepository(new DatabaseTypesRepository());
        ArrayList<String> schemaPatterns = new ArrayList<String>();
        schemaPatterns.add("SCOTT");
        parser.setSchemaPatterns(schemaPatterns);
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"EXTRA_SCHEMANAME_TEST_PACKAGE should parse", (boolean)worked);
        ProcedureType procedureType = packageType.getProcedures().get(0);
        if (procedureType.isFunctionType()) {
            FunctionType functionType = (FunctionType)procedureType;
            DatabaseType parm1DataType = functionType.getArguments().get(0).getEnclosedType();
            ArgumentType returnArgument = functionType.getReturnArgument();
            DatabaseType returnArgumentDataType = returnArgument.getEnclosedType();
            String returnArgumentDataTypeName = returnArgumentDataType.getTypeName();
            Assert.assertEquals((Object)"EMP%ROWTYPE", (Object)returnArgumentDataTypeName);
            Assert.assertSame((Object)parm1DataType, (Object)returnArgumentDataType);
        }
    }
}

