/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public abstract class MetadataColumn
extends ORMetadata {
    private String m_name;
    private String m_columnDefinition;

    protected MetadataColumn(MetadataAccessor accessor) {
        super(null, accessor);
    }

    protected MetadataColumn(MetadataAnnotation column, MetadataAccessor accessor) {
        super(column, accessor);
        if (column != null) {
            this.m_name = (String)column.getAttribute("name");
            this.m_columnDefinition = (String)column.getAttribute("columnDefinition");
        }
    }

    protected MetadataColumn(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MetadataColumn) {
            MetadataColumn column = (MetadataColumn)objectToCompare;
            if (!this.valuesMatch(this.m_columnDefinition, column.getColumnDefinition())) {
                return false;
            }
            return this.valuesMatch(this.m_name, column.getName());
        }
        return false;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getDatabaseField() {
        DatabaseField databaseField = new DatabaseField();
        this.setFieldName(databaseField, this.m_name == null ? "" : this.m_name);
        databaseField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        return databaseField;
    }

    public String getName() {
        return this.m_name;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

