/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.feature.Handler;

public class ExceptionHandlerLoginIntegrityTest
extends AutoVerifyTestCase {
    public Project project;
    public DatabaseSession session;
    public DatabaseLogin login;
    protected Exception caughtException = null;

    public ExceptionHandlerLoginIntegrityTest() {
        this.setDescription("To test if login IntegrityExceptions are passed to the ExceptionHandler");
    }

    public void test() {
        try {
            this.session = this.project.createDatabaseSession();
            this.session.dontLogMessages();
            Handler handler = new Handler();
            this.session.setExceptionHandler((ExceptionHandler)handler);
            this.session.login();
            this.session.logout();
        }
        catch (IntegrityException ie) {
            this.caughtException = ie;
        }
    }

    public void verify() throws Exception {
        if (this.caughtException != null) {
            throw new TestErrorException("Test to see if IntegrityExceptions caused at boot time are passed to the exceptionHandler failed.\n ----- ExceptionHandlerTest3 -----\n" + this.caughtException.getMessage());
        }
    }

    public void setup() {
        this.login = this.getSession().getLogin();
        this.project = new EmployeeProject();
        this.project.setLogin(this.login);
        Map descriptors = this.project.getDescriptors();
        ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(Employee.class);
        DirectToFieldMapping NonExistentFieldMapping = new DirectToFieldMapping();
        NonExistentFieldMapping.setAttributeName("nonExistent");
        descriptor.addMapping((DatabaseMapping)NonExistentFieldMapping);
    }
}

