/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedPhoneNumber;

public class IsolatedEmployeeProject
extends Project {
    public IsolatedEmployeeProject() {
        this.setName("IsolatedEmployee");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildAddressDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildEmployeeDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildEmploymentPeriodDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildPhoneNumberDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedAddress.class);
        descriptor.addTableName("ISOLATED_ADDRESS");
        descriptor.addPrimaryKeyFieldName("ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.setSequenceNumberFieldName("ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ISOLATED_ADDRESS.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ISOLATED_ADDRESS.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ISOLATED_ADDRESS.P_CODE");
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ISOLATED_ADDRESS.PROVINCE");
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ISOLATED_ADDRESS.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    public RelationalDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedEmployee.class);
        descriptor.addTableName("ISOLATED_EMPLOYEE");
        descriptor.addTableName("ISOLATED_SALARY");
        descriptor.addPrimaryKeyFieldName("ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setIsIsolated(true);
        descriptor.setUnitOfWorkCacheIsolationLevel(1);
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("ISOLATED_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("ISOLATED_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("ISOLATED_SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)salaryMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        ObjectTypeConverter genderConverter = new ObjectTypeConverter();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("ISOLATED_EMPLOYEE.GENDER");
        genderConverter.addConversionValue((Object)"M", (Object)"Male");
        genderConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMapping.setConverter((Converter)genderConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.setAttributeTransformation("buildNormalHours");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("ISOLATED_EMPLOYEE.END_TIME", "getEndTime");
        descriptor.addMapping((DatabaseMapping)normalHoursMapping);
        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(IsolatedEmploymentPeriod.class);
        periodMapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)periodMapping);
        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useBasicIndirection();
        responsibilitiesListMapping.setReferenceTableName("ISOLATED_RESPONS");
        responsibilitiesListMapping.setDirectFieldName("ISOLATED_RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("ISOLATED_RESPONS.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)responsibilitiesListMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(IsolatedAddress.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.ADDR_ID", "ISOLATED_ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(IsolatedEmployee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(IsolatedEmployee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("ISOLATED_EMPLOYEE.MANAGER_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(IsolatedPhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        return descriptor;
    }

    public RelationalDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(IsolatedEmploymentPeriod.class);
        DirectToFieldMapping endDateMapping = new DirectToFieldMapping();
        endDateMapping.setAttributeName("endDate");
        endDateMapping.setFieldName("END_DATE");
        descriptor.addMapping((DatabaseMapping)endDateMapping);
        DirectToFieldMapping startDateMapping = new DirectToFieldMapping();
        startDateMapping.setAttributeName("startDate");
        startDateMapping.setFieldName("START_DATE");
        descriptor.addMapping((DatabaseMapping)startDateMapping);
        return descriptor;
    }

    public RelationalDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(IsolatedPhoneNumber.class);
        descriptor.addTableName("ISOLATED_PHONE");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.EMP_ID");
        descriptor.addPrimaryKeyFieldName("ISOLATED_PHONE.TYPE");
        descriptor.setIsIsolated(true);
        descriptor.setUnitOfWorkCacheIsolationLevel(1);
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.addDirectQueryKey("id", "EMP_ID");
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("ISOLATED_PHONE.AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("ISOLATED_PHONE.P_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("ISOLATED_PHONE.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(IsolatedEmployee.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("ISOLATED_PHONE.EMP_ID", "ISOLATED_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)ownerMapping);
        descriptor.applyAmendmentMethod();
        return descriptor;
    }
}

