/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class NamedQueryQueryCacheTest
extends AutoVerifyTestCase {
    protected QuerySQLTracker tracker = null;
    protected Object results = null;
    protected int expectedSQLCount = 0;
    protected int expectedResults = 2;
    protected int queryLocation = 0;
    public static final int QUERY_ON_SESSION = 0;
    public static final int QUERY_ON_DESCRIPTOR = 1;
    public static final String CACHING_QUERY_NAME = "cachedResultsQuery";

    public NamedQueryQueryCacheTest() {
        this.setDescription("Test to ensure a query with caching enabled returns the cached results.");
    }

    public NamedQueryQueryCacheTest(int queryLocation) {
        this();
        this.queryLocation = queryLocation;
    }

    public ReadQuery getQueryForTest() {
        ReadAllQuery testQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like("B%");
        testQuery.setSelectionCriteria(exp);
        testQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        return testQuery;
    }

    public Session getSessionForQueryTest() {
        return this.getSession();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ReadQuery query = this.getQueryForTest();
        if (this.queryLocation == 1) {
            this.getSession().getDescriptor(query.getReferenceClass()).getQueryManager().addQuery(CACHING_QUERY_NAME, (DatabaseQuery)query);
            this.getSession().executeQuery(CACHING_QUERY_NAME, this.getQueryForTest().getReferenceClass());
        } else {
            this.getSession().addQuery(CACHING_QUERY_NAME, (DatabaseQuery)query);
            this.getSession().executeQuery(CACHING_QUERY_NAME);
        }
        this.tracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        this.results = this.queryLocation == 1 ? this.getSessionForQueryTest().executeQuery(CACHING_QUERY_NAME, this.getQueryForTest().getReferenceClass()) : this.getSessionForQueryTest().executeQuery(CACHING_QUERY_NAME);
    }

    public void verify() {
        if (this.tracker.getSqlStatements().size() != this.expectedSQLCount) {
            throw new TestErrorException("An incorrect number of SQL statements were generated: " + this.tracker.getSqlStatements().size() + ". This likely indicates a problem with the query cache.");
        }
        if (((Vector)this.results).size() != this.expectedResults) {
            throw new TestErrorException("The cached query did not yeild the correct number of results: " + ((Vector)this.results).size());
        }
    }

    public void reset() {
        this.tracker.remove();
        if (this.queryLocation == 1) {
            this.getSession().getDescriptor(this.getQueryForTest().getReferenceClass()).getQueryManager().removeQuery(CACHING_QUERY_NAME);
        } else {
            this.getSession().removeQuery(CACHING_QUERY_NAME);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

