/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class ScrollableCursorJoiningVerificationTest
extends TestCase {
    protected List<Employee> forwardCursoredResults;
    protected List<Employee> reverseCursoredResults;
    protected List<Employee> nonCursoredResults;

    public ScrollableCursorJoiningVerificationTest() {
        this.setDescription("ScrollableCursor test with joining, verifying query results");
    }

    public void test() {
        Employee result;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReadAllQuery nonCursoredQuery = new ReadAllQuery(Employee.class);
        nonCursoredQuery.dontCheckCache();
        nonCursoredQuery.addJoinedAttribute(nonCursoredQuery.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        nonCursoredQuery.addOrdering(nonCursoredQuery.getExpressionBuilder().get("id"));
        this.nonCursoredResults = (List)this.getSession().executeQuery((DatabaseQuery)nonCursoredQuery);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.forwardCursoredResults = new ArrayList<Employee>();
        ReadAllQuery cursoredQuery = new ReadAllQuery(Employee.class);
        nonCursoredQuery.dontCheckCache();
        cursoredQuery.useScrollableCursor();
        cursoredQuery.addJoinedAttribute(cursoredQuery.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        cursoredQuery.addOrdering(cursoredQuery.getExpressionBuilder().get("id"));
        ScrollableCursor cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)cursoredQuery);
        while (cursor.hasNext()) {
            result = (Employee)cursor.next();
            this.forwardCursoredResults.add(result);
        }
        this.reverseCursoredResults = new ArrayList<Employee>();
        while (cursor.hasPrevious()) {
            result = (Employee)cursor.previous();
            this.reverseCursoredResults.add(result);
        }
        cursor.close();
    }

    public void verify() {
        ScrollableCursorJoiningVerificationTest.assertNotSame((String)"Test data for non-cursored results should be nonzero", (Object)0, (Object)this.nonCursoredResults.size());
        ScrollableCursorJoiningVerificationTest.assertNotSame((String)"Test data for cursored results should be nonzero", (Object)0, (Object)this.forwardCursoredResults.size());
        ScrollableCursorJoiningVerificationTest.assertNotSame((String)"Test data for reverse-cursored results should be nonzero", (Object)0, (Object)this.reverseCursoredResults.size());
        ScrollableCursorJoiningVerificationTest.assertSame((String)"Cursored results should be the same size as non-cursored results", (Object)this.nonCursoredResults.size(), (Object)this.forwardCursoredResults.size());
        ScrollableCursorJoiningVerificationTest.assertSame((String)"Reverse cursored results should be the same size as non-cursored results", (Object)this.nonCursoredResults.size(), (Object)this.reverseCursoredResults.size());
        if (!this.compareEmployeeLists(this.nonCursoredResults, this.forwardCursoredResults)) {
            ScrollableCursorJoiningVerificationTest.failNotEquals((String)"Cursored and non-cursored results should be equal", this.nonCursoredResults, this.forwardCursoredResults);
        }
        ArrayList<Employee> reversedReverseCursoredResults = new ArrayList<Employee>(this.reverseCursoredResults);
        Collections.reverse(reversedReverseCursoredResults);
        if (!this.compareEmployeeLists(this.nonCursoredResults, reversedReverseCursoredResults)) {
            ScrollableCursorJoiningVerificationTest.assertEquals((String)"Reverse cursored and non-cursored results should be equal", this.nonCursoredResults, reversedReverseCursoredResults);
        }
    }

    public boolean compareEmployeeLists(List<Employee> expectedList, List<Employee> actualList) {
        for (int i = 0; i < expectedList.size(); ++i) {
            Employee expectedEmployee = expectedList.get(i);
            Employee actualEmployee = actualList.get(i);
            if (!(expectedEmployee.getId().equals(actualEmployee.getId()) && expectedEmployee.getFirstName().equals(actualEmployee.getFirstName()) && expectedEmployee.getLastName().equals(actualEmployee.getLastName()))) {
                return false;
            }
            for (PhoneNumber expectedPhoneNumber : expectedEmployee.getPhoneNumbers()) {
                boolean phoneInList = false;
                for (int j = 0; j < actualEmployee.getPhoneNumbers().size(); ++j) {
                    PhoneNumber actualPhoneNumber = (PhoneNumber)actualEmployee.getPhoneNumbers().get(j);
                    if (!expectedPhoneNumber.getAreaCode().equals(actualPhoneNumber.getAreaCode()) || !expectedPhoneNumber.getNumber().equals(actualPhoneNumber.getNumber()) || !expectedPhoneNumber.getType().equals(actualPhoneNumber.getType())) continue;
                    phoneInList = true;
                    break;
                }
                if (phoneInList) continue;
                return false;
            }
        }
        return true;
    }

    public void reset() {
        this.forwardCursoredResults = null;
        this.nonCursoredResults = null;
    }
}

