/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.events.AboutToInsertMultiTableObject;
import org.eclipse.persistence.testing.models.events.AboutToInsertSingleTableObject;
import org.eclipse.persistence.testing.models.events.EventHookSystem;
import org.eclipse.persistence.testing.tests.events.AboutToInsertEventTest;
import org.eclipse.persistence.testing.tests.events.MultipleTableAboutToInsertTest;
import org.eclipse.persistence.testing.tests.events.SingleTableAboutToInsertTest;
import org.eclipse.persistence.testing.tests.simultaneous.AddDescriptorsMultithreadedTest;
import org.eclipse.persistence.testing.tests.simultaneous.AppendLockTest;
import org.eclipse.persistence.testing.tests.simultaneous.ConcurrencyTest;
import org.eclipse.persistence.testing.tests.simultaneous.ConcurrentDecryptionTest;
import org.eclipse.persistence.testing.tests.simultaneous.ConcurrentReadFetchJoinTest;
import org.eclipse.persistence.testing.tests.simultaneous.ConcurrentReadFetchJoinWithUOWLocksTest;
import org.eclipse.persistence.testing.tests.simultaneous.ConcurrentReadOneToOneInheritanceTest;
import org.eclipse.persistence.testing.tests.simultaneous.DescriptorQueryManagerMultithreadedTest;
import org.eclipse.persistence.testing.tests.simultaneous.MultithreadTestCase;
import org.eclipse.persistence.testing.tests.simultaneous.QueryCacheMultithreadedTest;
import org.eclipse.persistence.testing.tests.simultaneous.UpdateCacheKeyPropertiesTest;
import org.eclipse.persistence.testing.tests.unitofwork.UOWSystem;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class SimultaneousTestsModel
extends TestModel {
    protected Session originalSession;

    public static junit.framework.TestSuite suite() {
        return new SimultaneousTestsModel();
    }

    public SimultaneousTestsModel() {
        this.setDescription("This model runs MultithreadTestCases.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new EventHookSystem());
        this.addRequiredSystem(new UOWSystem());
    }

    public void addTests() {
        this.addTest((Test)new ConcurrencyTest());
        this.addTest((Test)new AppendLockTest());
        this.addTest((Test)new UpdateCacheKeyPropertiesTest());
        this.addTest((Test)SimultaneousTestsModel.getReadEmployeeTestSuite());
        this.addTest((Test)SimultaneousTestsModel.getAboutToUpdateEventTestSuite());
        this.addTest((Test)SimultaneousTestsModel.getDescriptorQueryManagerAddQueryTest());
        this.addTest((Test)SimultaneousTestsModel.getQueryCacheMultithreadedTest());
        this.addTest((Test)new ConcurrentDecryptionTest());
        this.addTest((Test)new ConcurrentReadOneToOneInheritanceTest());
        this.addTest((Test)new ConcurrentReadFetchJoinTest());
        this.addTest((Test)new ConcurrentReadFetchJoinWithUOWLocksTest());
        this.addTest((Test)AddDescriptorsMultithreadedTest.AddDescriptorsTest.createMultithreadedTest(3, 0L));
        this.addTest((Test)AddDescriptorsMultithreadedTest.SequencePreallocationTest.createMultithreadedTest(10, 10000L));
        this.addTest((Test)AddDescriptorsMultithreadedTest.SequencePreallocationTest.createMultithreadedTestWithAddDescriptors(1, 100L, 10));
        this.addTest((Test)AddDescriptorsMultithreadedTest.InsertTest.createMultithreadedTest(10, 10000L));
        this.addTest((Test)AddDescriptorsMultithreadedTest.InsertTest.createMultithreadedTestWithAddDescriptors(1, 100L, 10));
    }

    public static TestSuite getReadEmployeeTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Employee Multithread Test Suite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        Vector<Object> tests = new Vector<Object>();
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        tests.add(new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        tests.add(new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        tests.add(new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        tests.add(new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        tests.add(new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        tests.add(test);
        tests.add(new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        tests.add(new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        tests.add(new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        tests.add(new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        tests.add(new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        tests.add(new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        tests.add(new ReadAllTest(Employee.class, 12));
        tests.add(new ReadAllTest(Project.class, 15));
        tests.add(new ReadAllTest(LargeProject.class, 5));
        tests.add(new ReadAllTest(SmallProject.class, 10));
        suite.addTest((Test)new MultithreadTestCase(tests));
        return suite;
    }

    public static TestSuite getAboutToUpdateEventTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("About to Update Multithread Test Suite");
        suite.setDescription("This suite tests use of aboutToUpdateEvents to change what is going to the database.");
        Vector<AboutToInsertEventTest> tests = new Vector<AboutToInsertEventTest>();
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        tests.add(new SingleTableAboutToInsertTest(new AboutToInsertSingleTableObject(), true));
        tests.add(new MultipleTableAboutToInsertTest(new AboutToInsertMultiTableObject(), true));
        MultithreadTestCase test = new MultithreadTestCase(tests);
        test.useSequenceConnectionPool();
        suite.addTest((Test)test);
        return suite;
    }

    public static TestSuite getDescriptorQueryManagerAddQueryTest() {
        TestSuite suite = new TestSuite();
        suite.setName("DescriptorQueryManagerAddQueryTest");
        suite.setDescription("This suite tests use of descriptorQueryManager.addQuery() when called simultaneously with multiple threads..");
        suite.addTest((Test)new DescriptorQueryManagerMultithreadedTest());
        return suite;
    }

    public static TestSuite getQueryCacheMultithreadedTest() {
        TestSuite suite = new TestSuite();
        suite.setName("QueryCacheMultithreadedTest");
        suite.setDescription("This suite runs queries with cached results many times in different threads.");
        suite.addTest((Test)new QueryCacheMultithreadedTest());
        return suite;
    }
}

