/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;

public class WorkingCloneCopyPolicyTest
extends AutoVerifyTestCase {
    protected CopyPolicy originalPolicy;
    protected ClassDescriptor descriptor;

    public WorkingCloneCopyPolicyTest() {
        this.setDescription("Verify that the working clone copy policy is used correctly.");
    }

    public void reset() {
        this.descriptor.setCopyPolicy(this.originalPolicy);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.descriptor = this.getSession().getDescriptor(Address.class);
        this.originalPolicy = this.descriptor.getCopyPolicy();
        this.descriptor.setCopyPolicy((CopyPolicy)new WorkingCloneCopyPolicy());
        this.descriptor.getCopyPolicy().initialize(this.getSession());
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Address address = (Address)uow.readObject(Address.class);
        if (!address.isWorkingCopy) {
            throw new TestErrorException("Failed to call the correct copy policy method");
        }
        if (((Address)((UnitOfWorkImpl)uow).getBackupClone((Object)address)).isWorkingCopy) {
            throw new TestErrorException("Updated the backup clone with the working copy specific information");
        }
    }

    protected void verify() throws Exception {
    }

    protected class WorkingCloneCopyPolicy
    extends CloneCopyPolicy {
        protected WorkingCloneCopyPolicy() {
        }

        public Object buildClone(Object domainObject, Session session) throws DescriptorException {
            return super.buildClone(domainObject, session);
        }

        public Object buildWorkingCopyClone(Object domainObject, Session session) throws DescriptorException {
            Object workingClone = this.buildClone(domainObject, session);
            if (workingClone instanceof Address) {
                ((Address)workingClone).isWorkingCopy = true;
            }
            return workingClone;
        }
    }
}

