/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.math.BigInteger;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.inheritance.Boat;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Car;
import org.eclipse.persistence.testing.models.jpa.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Jalopy;
import org.eclipse.persistence.testing.models.jpa.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.inheritance.Vehicle;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.BlueLight;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;

public class QueryCastTestSuite
extends JUnitTestCase {
    public QueryCastTestSuite() {
    }

    public QueryCastTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("QueryCastTestSuite");
        suite.addTest((Test)new QueryCastTestSuite("testSetup"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyLeafQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyMidHierarchyQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastManyToManyQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyLeafExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastOneToManyMidHierarchyExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastManyToManyExpressionBuilder"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastInSelect"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastSingleTableQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastOneToManyLeafQueryKey"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastSeparateClass"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastRelationshipTraversal"));
        suite.addTest((Test)new QueryCastTestSuite("testDoubleDowncastOneToOne"));
        suite.addTest((Test)new QueryCastTestSuite("testSelectCast"));
        suite.addTest((Test)new QueryCastTestSuite("testCastInSubselect"));
        suite.addTest((Test)new QueryCastTestSuite("testDowncastWithFetchJoin"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        if (QueryCastTestSuite.getServerSession().getPlatform().isPostgreSQL()) {
            QueryCastTestSuite.getServerSession().getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public void testDowncastOneToManyLeafQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        em.persist((Object)car);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        boat = new Boat();
        boat.setModel("fishing");
        em.persist((Object)boat);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select c from Company c join treat(c.vehicles as Boat) b where b.model = 'speed'");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastOneToManyMidHierarchyQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        em.persist((Object)car);
        NonFueledVehicle nfv = new NonFueledVehicle();
        nfv.setColor("Blue");
        em.persist((Object)nfv);
        company.getVehicles().add(nfv);
        nfv.setOwner(company);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        nfv = new NonFueledVehicle();
        nfv.setColor("Red");
        em.persist((Object)nfv);
        company.getVehicles().add(nfv);
        nfv.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select c from Company c join treat(c.vehicles as NonFueledVehicle) v where v.color = 'Blue'");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastManyToManyQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject proj = new LargeProject();
        proj.setBudget(1000.0);
        proj.setName("test1");
        em.persist((Object)proj);
        SmallProject sp = new SmallProject();
        sp.setName("sp1");
        em.persist((Object)sp);
        Employee emp = new Employee();
        emp.setFirstName("Reggie");
        emp.setLastName("Josephson");
        emp.addProject((Project)proj);
        proj.addTeamMember(emp);
        emp.addProject((Project)sp);
        sp.addTeamMember(emp);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("Ron");
        emp.setLastName("Josephson");
        emp.addProject((Project)sp);
        sp.addTeamMember(emp);
        em.persist((Object)emp);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select e from Employee e join treat(e.projects as LargeProject) p where p.budget > 100");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastOneToManyLeafExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        em.persist((Object)car);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        boat = new Boat();
        boat.setModel("fishing");
        em.persist((Object)boat);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        JpaQuery query = (JpaQuery)em.createQuery("Select v from Vehicle v");
        ReadAllQuery raq = new ReadAllQuery(Vehicle.class);
        query.setDatabaseQuery((DatabaseQuery)raq);
        ExpressionBuilder exp = raq.getExpressionBuilder();
        Expression criteria = exp.treat(Boat.class).get("model").equal((Object)"speed");
        raq.setSelectionCriteria(criteria);
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastOneToManyMidHierarchyExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        boat.setColor("Blue");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        em.persist((Object)car);
        NonFueledVehicle nfv = new NonFueledVehicle();
        nfv.setColor("Blue");
        em.persist((Object)nfv);
        company.getVehicles().add(nfv);
        nfv.setOwner(company);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        nfv = new NonFueledVehicle();
        nfv.setColor("Red");
        em.persist((Object)nfv);
        company.getVehicles().add(nfv);
        nfv.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        JpaQuery query = (JpaQuery)em.createQuery("Select v from Vehicle v");
        ReadAllQuery raq = new ReadAllQuery(Vehicle.class);
        query.setDatabaseQuery((DatabaseQuery)raq);
        ExpressionBuilder exp = raq.getExpressionBuilder();
        Expression criteria = exp.treat(NonFueledVehicle.class).get("color").equal((Object)"Blue");
        raq.setSelectionCriteria(criteria);
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastManyToManyExpressionBuilder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject proj = new LargeProject();
        proj.setBudget(1000.0);
        proj.setName("test1");
        em.persist((Object)proj);
        SmallProject sp = new SmallProject();
        sp.setName("sp1");
        em.persist((Object)sp);
        Employee emp = new Employee();
        emp.setFirstName("Reggie");
        emp.setLastName("Josephson");
        emp.addProject((Project)proj);
        proj.addTeamMember(emp);
        emp.addProject((Project)sp);
        sp.addTeamMember(emp);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("Ron");
        emp.setLastName("Josephson");
        emp.addProject((Project)sp);
        sp.addTeamMember(emp);
        em.persist((Object)emp);
        em.flush();
        this.clearCache();
        em.clear();
        JpaQuery query = (JpaQuery)em.createQuery("Select p from Project p");
        ReadAllQuery raq = new ReadAllQuery(Project.class);
        query.setDatabaseQuery((DatabaseQuery)raq);
        ExpressionBuilder exp = raq.getExpressionBuilder();
        Expression criteria = exp.treat(LargeProject.class).get("budget").greaterThan(100);
        raq.setSelectionCriteria(criteria);
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastInSelect() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject proj = new LargeProject();
        proj.setBudget(1000.0);
        proj.setName("test1");
        em.persist((Object)proj);
        SmallProject sp = new SmallProject();
        sp.setName("sp1");
        em.persist((Object)sp);
        em.flush();
        this.clearCache();
        em.clear();
        ExpressionBuilder builder = new ExpressionBuilder(Project.class);
        ReportQuery rq = new ReportQuery(Project.class, builder);
        rq.addAttribute("project", builder.treat(LargeProject.class).get("budget"));
        rq.setSelectionCriteria(builder.type().equal(LargeProject.class));
        List resultList = (List)((JpaEntityManager)em.getDelegate()).getActiveSession().executeQuery((DatabaseQuery)rq);
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastSingleTableQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer consumer = new BeerConsumer();
        consumer.setName("John");
        em.persist((Object)consumer);
        Blue blue = new Blue();
        blue.setAlcoholContent((Object)Float.valueOf(5.0f));
        blue.setUniqueKey(new BigInteger("4531"));
        em.persist((Object)blue);
        BlueLight blueLight = new BlueLight();
        blueLight.setDiscount(10);
        blueLight.setUniqueKey(new BigInteger("4533"));
        em.persist((Object)blueLight);
        consumer.addBlueBeerToConsume((Blue)blueLight);
        blueLight.setBeerConsumer(consumer);
        consumer.addBlueBeerToConsume(blue);
        consumer.addBlueBeerToConsume((Blue)blueLight);
        consumer = new BeerConsumer();
        consumer.setName("Frank");
        em.persist((Object)consumer);
        blueLight = new BlueLight();
        blueLight.setDiscount(5);
        blueLight.setUniqueKey(new BigInteger("4532"));
        em.persist((Object)blueLight);
        consumer.addBlueBeerToConsume((Blue)blueLight);
        blueLight.setBeerConsumer(consumer);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select b from BeerConsumer b join treat(b.blueBeersToConsume as BlueLight) bl where bl.discount = 10");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDoubleDowncastOneToManyLeafQueryKey() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        car.setFuelType("unleaded");
        em.persist((Object)car);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        boat = new Boat();
        boat.setModel("fishing");
        em.persist((Object)boat);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select c from Company c join treat(c.vehicles as Boat) b where b.model = 'speed' or b.model = 'fishing'");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDoubleDowncastSeparateClass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Car car = new Car();
        car.setDescription("A car");
        car.setFuelType("unleaded");
        em.persist((Object)car);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(car);
        car.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        boat = new Boat();
        boat.setModel("fishing");
        em.persist((Object)boat);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select distinct c from Company c left join treat(c.vehicles as Boat) b left join treat(c.vehicles as FueledVehicle) f where b.model = 'fishing' or f.fuelType = 'unleaded'");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testDowncastRelationshipTraversal() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Company company = new Company();
        company.setName("Acme");
        em.persist((Object)company);
        Boat boat = new Boat();
        boat.setModel("speed");
        em.persist((Object)boat);
        Bus bus = new Bus();
        bus.setDescription("A bus");
        bus.setFuelType("unleaded");
        em.persist((Object)bus);
        Person person = new Person();
        person.setName("Driver");
        bus.setBusDriver(person);
        em.persist((Object)person);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        company.getVehicles().add(bus);
        bus.setOwner(company);
        company = new Company();
        company.setName("WidgetCo");
        em.persist((Object)company);
        bus = new Bus();
        bus.setDescription("B bus");
        bus.setFuelType("unleaded");
        em.persist((Object)bus);
        person = new Person();
        person.setName("Driver2");
        bus.setBusDriver(person);
        em.persist((Object)person);
        company.getVehicles().add(boat);
        boat.setOwner(company);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select distinct c from Company c left join treat(c.vehicles as Bus) b where b.busDriver.name = 'Driver'");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleDowncastOneToOne() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Person rudy = new Person();
        rudy.setName("Rudy");
        em.persist((Object)rudy);
        SportsCar sportsCar = new SportsCar();
        sportsCar.setMaxSpeed(200);
        em.persist((Object)sportsCar);
        rudy.setCar((Car)sportsCar);
        Person theo = new Person();
        theo.setName("Theo");
        em.persist((Object)theo);
        Jalopy car = new Jalopy();
        car.setColor("Red");
        car.setPercentRust(20);
        em.persist((Object)car);
        theo.setCar((Car)car);
        em.flush();
        this.clearCache();
        em.clear();
        try {
            Query query = em.createQuery("Select distinct p from Person p left join treat(p.car as SportsCar) s left join treat(p.car as Jalopy) j where s.maxSpeed = 200 or j.percentRust = 20");
            List resultList = query.getResultList();
            QueryCastTestSuite.assertTrue((String)"Incorrect results returned", (resultList.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testSelectCast() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject proj = new LargeProject();
        proj.setBudget(1000.0);
        proj.setName("test1");
        em.persist((Object)proj);
        LargeProject lp = new LargeProject();
        lp.setBudget(100.0);
        lp.setName("sp1");
        em.persist((Object)lp);
        Employee emp = new Employee();
        emp.setFirstName("Reggie");
        emp.setLastName("Josephson");
        emp.addProject((Project)proj);
        proj.addTeamMember(emp);
        emp.addProject((Project)lp);
        lp.addTeamMember(emp);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("Ron");
        emp.setLastName("Josephson");
        emp.addProject((Project)lp);
        lp.addTeamMember(emp);
        em.persist((Object)emp);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("Select max(l.budget) from Employee e join treat(e.projects as LargeProject) l");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
        QueryCastTestSuite.assertTrue((String)"Incorrect results returned", ((Double)resultList.get(0) == 1000.0 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testCastInSubselect() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject proj = new LargeProject();
        proj.setBudget(1000.0);
        proj.setName("test1");
        em.persist((Object)proj);
        LargeProject lp = new LargeProject();
        lp.setBudget(100.0);
        lp.setName("sp1");
        em.persist((Object)lp);
        Employee emp = new Employee();
        emp.setFirstName("Reggie");
        emp.setLastName("Josephson");
        emp.addProject((Project)proj);
        proj.addTeamMember(emp);
        emp.addProject((Project)lp);
        lp.addTeamMember(emp);
        emp.setSalary(10000);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("Ron");
        emp.setLastName("Josephson");
        emp.addProject((Project)lp);
        lp.addTeamMember(emp);
        em.persist((Object)emp);
        emp.setSalary(100);
        em.flush();
        this.clearCache();
        em.clear();
        Query query = em.createQuery("select e from Employee e where e.salary > (Select max(l.budget) from Employee emp join treat(emp.projects as LargeProject) l)");
        List resultList = query.getResultList();
        QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDowncastWithFetchJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Person rudy = new Person();
        rudy.setName("Rudy");
        em.persist((Object)rudy);
        SportsCar sportsCar = new SportsCar();
        sportsCar.setMaxSpeed(200);
        em.persist((Object)sportsCar);
        rudy.setCar((Car)sportsCar);
        Person theo = new Person();
        theo.setName("Theo");
        em.persist((Object)theo);
        Jalopy car = new Jalopy();
        car.setColor("Red");
        car.setPercentRust(20);
        em.persist((Object)car);
        theo.setCar((Car)car);
        em.flush();
        this.clearCache();
        em.clear();
        try {
            Query query = em.createQuery("Select p from Person p join fetch p.car join treat(p.car as SportsCar) s where s.maxSpeed = 200");
            List resultList = query.getResultList();
            Person person = (Person)resultList.get(0);
            QueryCastTestSuite.assertTrue((String)"Incorrect result size returned", (resultList.size() == 1 ? 1 : 0) != 0);
            QueryCastTestSuite.assertNotNull((String)"The car was not fetched.", (Object)person.car);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }
}

