/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.QuerySQLTracker;
import org.eclipse.persistence.testing.tests.jpa.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeUpdateTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static Server serverSession = null;
    static DynamicEmployeeSystem deSystem = null;
    static QuerySQLTracker qTracker = null;

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        boolean isMySQL = JpaHelper.getServerSession((EntityManagerFactory)emf).getDatasourcePlatform().getClass().getName().contains("MySQLPlatform");
        Assume.assumeTrue((boolean)isMySQL);
        helper = new JPADynamicHelper(emf);
        deSystem = DynamicEmployeeSystem.buildProject((DynamicHelper)helper);
        serverSession = JpaHelper.getServerSession((EntityManagerFactory)emf);
        deSystem.populate(helper, emf.createEntityManager());
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        qTracker = QuerySQLTracker.install((Session)serverSession);
        serverSession.setLogLevel(3);
    }

    @AfterClass
    public static void tearDown() {
        serverSession.executeNonSelectingSQL("DROP TABLE D_SALARY");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PROJECT");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PHONE");
        serverSession.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
        serverSession.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        helper = null;
        qTracker = null;
        emf.close();
        emf = null;
    }

    @Test
    public void testMultipleTransactionsModifyInstance() {
        EntityManager em = emf.createEntityManager();
        qTracker.reset();
        DynamicEntity minEmp = this.minimumEmployee(em);
        em.getTransaction().begin();
        minEmp.set("firstName", (Object)"Delete");
        minEmp.set("lastName", (Object)"Delete");
        minEmp.set("salary", (Object)9);
        em.persist((Object)minEmp);
        em.getTransaction().commit();
        Assert.assertEquals((long)1L, (long)qTracker.getTotalCalls("ReadAll"));
        Assert.assertEquals((long)2L, (long)qTracker.getTotalSQLUPDATECalls());
        Assert.assertTrue((boolean)(minEmp instanceof ChangeTracker));
        Assert.assertNotNull((Object)((ChangeTracker)minEmp)._persistence_getPropertyChangeListener());
        Assert.assertTrue((boolean)(((ChangeTracker)minEmp)._persistence_getPropertyChangeListener() instanceof AttributeChangeListener));
        qTracker.reset();
        DynamicEntity period = (DynamicEntity)minEmp.get("period");
        period.set("startDate", (Object)new Date(System.currentTimeMillis()));
        period.set("endDate", (Object)new Date(System.currentTimeMillis() + 100000L));
        em.getTransaction().begin();
        em.persist((Object)minEmp);
        em.getTransaction().commit();
        Assert.assertEquals((long)1L, (long)qTracker.getTotalSQLUPDATECalls());
    }

    public DynamicEntity minimumEmployee(EntityManager em) {
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.id in (SELECT MIN(ee.id) FROM Employee ee)");
        return (DynamicEntity)q.getSingleResult();
    }
}

