/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StronglyTypedCursorDDLTestSuite {
    static final String CREATE_PACKAGE_PREFIX = "CREATE PACKAGE ";
    static final String CURSOR_PACKAGE = "STRONGLY_TYPED_REF_CURSOR_TEST";
    static final String CREATE_CURSOR_PACKAGE = "CREATE PACKAGE STRONGLY_TYPED_REF_CURSOR_TEST AS\nTYPE STRONGLY_TYPED_REF_CURSOR IS REF CURSOR RETURN STRC_TABLE%ROWTYPE;\nPROCEDURE GET_EMS(P_EMS STRC_TABLE.NAME%TYPE, P_EMS_SET OUT STRONGLY_TYPED_REF_CURSOR);\nEND STRONGLY_TYPED_REF_CURSOR_TEST;";
    static DDLParser parser = null;

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testCursorPackage() {
        parser.ReInit(new StringReader(CREATE_CURSOR_PACKAGE));
        boolean worked = true;
        PLSQLPackageType packageType = null;
        try {
            packageType = parser.parsePLSQLPackage();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"cursor package should parse", (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(packageType);
        Assert.assertTrue((String)"cursor package should contain two unresolved datatypes", (l.getUnresolvedTypes().size() == 2 ? 1 : 0) != 0);
    }
}

