/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;

public abstract class AbstractLiteralExpressionFactory
extends ExpressionFactory {
    protected AbstractLiteralExpressionFactory(String id) {
        super(id, new String[0]);
    }

    protected abstract AbstractExpression buildExpression(AbstractExpression var1, WordParser var2, String var3, AbstractExpression var4, boolean var5);

    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        ExpressionFactory factory;
        switch (wordParser.getWordType()) {
            case NUMERIC_LITERAL: {
                expression = new NumericLiteral(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
            case STRING_LITERAL: {
                expression = new StringLiteral(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
            case INPUT_PARAMETER: {
                expression = new InputParameter(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
        }
        if (word.indexOf(46) > -1) {
            char character = word.charAt(0);
            expression = expression != null && character == '.' ? (this.isCollection() ? new CollectionValuedPathExpression(parent, expression, word) : new StateFieldPathExpression(parent, expression, word)) : (this.isCollection() ? new CollectionValuedPathExpression(parent, word) : new StateFieldPathExpression(parent, word));
            expression.parse(wordParser, tolerant);
            return expression;
        }
        ExpressionRegistry registry = this.getExpressionRegistry();
        if (tolerant && registry.isIdentifier(word) && (factory = registry.expressionFactoryForIdentifier(word)) != null && (expression = factory.buildExpression(parent, wordParser, word, queryBNF, expression, tolerant)) != null) {
            return new BadExpression(parent, expression);
        }
        return this.buildExpression(parent, wordParser, word, expression, tolerant);
    }

    protected boolean isCollection() {
        return false;
    }
}

