/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.AbstractLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.BooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

abstract class AbstractRdbmsLoginPane
extends AbstractLoginPane {
    private JComponent databaseSourcePane;
    private JComponent driverManagerPane;

    public AbstractRdbmsLoginPane(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    private CollectionValueModel buildDatabaseDriverCollectionHolder() {
        Vector<Boolean> booleanValues = new Vector<Boolean>();
        booleanValues.add(Boolean.TRUE);
        booleanValues.add(Boolean.FALSE);
        return new ReadOnlyCollectionValueModel(booleanValues);
    }

    private ComboBoxModel buildDatabaseDriverComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildDatabaseDriverCollectionHolder(), this.buildDatabaseDriverSelectionHolder());
    }

    private PropertyValueModel buildDatabaseDriverHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "useDriverManager"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.databaseDriverIsDriverManager();
            }
        };
    }

    private CellRendererAdapter buildDatabaseDriverLabelDecorator() {
        ResourceRepository resourceRepository = this.resourceRepository();
        return new BooleanCellRendererAdapter(resourceRepository.getString("CONNECTION_RDBMS_DRIVER_MANAGER_CHOICE"), resourceRepository.getString("CONNECTION_RDBMS_DATA_SOURCE_CHOICE"));
    }

    protected abstract PropertyValueModel buildDatabaseDriverSelectionHolder();

    private SwitcherPanel buildDatabaseDriverSwitcherPanel() {
        this.getDriverManagerPane();
        this.getDataSourcePane();
        return new SwitcherPanel(this.buildDatabaseDriverHolder(), this.buildDatabaseDriverTransformer());
    }

    private Transformer buildDatabaseDriverTransformer() {
        return new Transformer(){

            public Object transform(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)AbstractRdbmsLoginPane.this.subject();
                if (value == null || login == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(value)) {
                    return AbstractRdbmsLoginPane.this.getDriverManagerPane();
                }
                return AbstractRdbmsLoginPane.this.getDataSourcePane();
            }
        };
    }

    private Document buildDataSourceNameDocumentAdapter() {
        return new DocumentAdapter(this.buildDataSourceNameHolder());
    }

    private PropertyValueModel buildDataSourceNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dataSource"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.getDataSourceName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setDataSourceName((String)value);
            }
        };
    }

    private JComponent buildDataSourcePane() {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane panel = new Pane(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JComponent lookupTypeWidgets = this.buildLabeledComboBox("CONNECTION_RDBMS_LOOKUP_TYPE_FIELD", this.buildLookupTypeComboModel(), this.buildLookupTypeCellRenderer());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)lookupTypeWidgets, constraints);
        JComponent nameWidgets = this.buildLabeledTextField("CONNECTION_RDBMS_DATA_SOURCE_FIELD", this.buildDataSourceNameDocumentAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)nameWidgets, constraints);
        return panel;
    }

    private JButton buildDriverClassBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "CONNECTION_RDBMS_DRIVER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildDriverClassHolder());
    }

    private ListValueModel buildDriverClassCollectionHolder() {
        Collection driverClasses = CollectionTools.collection((Iterator)DatabaseLoginAdapter.driverClasses());
        ReadOnlyCollectionValueModel collectionHolder = new ReadOnlyCollectionValueModel(driverClasses);
        return new SortedListValueModelAdapter(collectionHolder);
    }

    private ComboBoxModel buildDriverClassComboAdapter() {
        return new ComboBoxModelAdapter(this.buildDriverClassCollectionHolder(), this.buildDriverClassHolder());
    }

    private PropertyValueModel buildDriverClassHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "driverClass"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.getDriverClassName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setDriverClassName((String)value);
            }
        };
    }

    private JComponent buildDriverManagerPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane panel = new Pane(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JComboBox<String> driverClassComboBox = new JComboBox<String>(this.buildDriverClassComboAdapter());
        driverClassComboBox.setEditable(true);
        driverClassComboBox.setPrototypeDisplayValue("m");
        JTextField textField = (JTextField)driverClassComboBox.getEditor().getEditorComponent();
        textField.setDocument(RegexpDocument.buildDocument(3));
        JComponent driverClassWidgets = this.buildLabeledComponent("CONNECTION_RDBMS_DRIVER_CLASS_COMBO_BOX", driverClassComboBox, this.buildDriverClassBrowseButton());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)driverClassWidgets, constraints);
        JComponent driverURLWidgets = this.buildLabeledEditableComboBox("CONNECTION_RDBMS_DRIVER_URL_COMBO_BOX", this.buildDriverURLComboAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)driverURLWidgets, constraints);
        return panel;
    }

    private ListValueModel buildDriverURLCollectionHolder() {
        return new SortedListValueModelAdapter(new CollectionAspectAdapter(this.buildDriverClassHolder()){

            @Override
            protected Iterator getValueFromSubject() {
                return DatabaseLoginAdapter.driverURLs((String)this.subject);
            }
        });
    }

    private ComboBoxModel buildDriverURLComboAdapter() {
        return new ComboBoxModelAdapter(this.buildDriverURLCollectionHolder(), this.buildDriverURLHolder());
    }

    private PropertyValueModel buildDriverURLHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "connectionURL"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                return login.getConnectionURL();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                login.setConnectionURL((String)value);
            }
        };
    }

    private ListCellRenderer buildLookupTypeCellRenderer() {
        return new AdaptableListCellRenderer(new AbstractCellRendererAdapter(){

            @Override
            public String buildText(Object value) {
                LookupType lookupType = (LookupType)value;
                return lookupType.displayString();
            }
        });
    }

    private ListValueModel buildLookupTypeCollectionHolder(List lookupChoices) {
        return new ReadOnlyListValueModel(lookupChoices);
    }

    private ComboBoxModel buildLookupTypeComboModel() {
        LookupType string = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_STRING_CHOICE"), new Integer(1));
        LookupType compound = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_COMPOUND_NAME_CHOICE"), new Integer(3));
        LookupType composite = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_COMPOSITE_NAME_CHOICE"), new Integer(2));
        Vector<LookupType> lookupTypes = new Vector<LookupType>(3);
        lookupTypes.add(string);
        lookupTypes.add(compound);
        lookupTypes.add(composite);
        CollectionTools.sort(lookupTypes, (Comparator)this.buildLookupTypeComparator());
        return new ComboBoxModelAdapter(this.buildLookupTypeCollectionHolder(lookupTypes), this.buildLookupTypeHolder(lookupTypes));
    }

    private Comparator buildLookupTypeComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                LookupType lookupType1 = (LookupType)object1;
                LookupType lookupType2 = (LookupType)object2;
                return Displayable.DEFAULT_COLLATOR.compare(lookupType1.displayString(), lookupType2.displayString());
            }
        };
    }

    private PropertyValueModel buildLookupTypeHolder(final List lookupChoices) {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "lookup"){

            private LookupType findLookupType(List lookupChoices2, Integer lookupValue) {
                int index = lookupChoices2.size();
                while (--index >= 0) {
                    LookupType choice = (LookupType)lookupChoices2.get(index);
                    if (choice.lookupValue().intValue() != lookupValue.intValue()) continue;
                    return choice;
                }
                return null;
            }

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return this.findLookupType(lookupChoices, adapter.getLookupType());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                LookupType lookupType = (LookupType)value;
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setLookupType(lookupType.lookupValue());
            }
        };
    }

    private Component getDataSourcePane() {
        if (this.databaseSourcePane == null) {
            this.databaseSourcePane = this.buildDataSourcePane();
        }
        return this.databaseSourcePane;
    }

    private JComponent getDriverManagerPane() {
        if (this.driverManagerPane == null) {
            this.driverManagerPane = this.buildDriverManagerPane();
        }
        return this.driverManagerPane;
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent databaseDriverWidgets = this.buildLabeledComboBox("CONNECTION_RDBMS_DATABASE_DRIVER_COMBO_BOX", this.buildDatabaseDriverComboBoxAdapter(), new AdaptableListCellRenderer(this.buildDatabaseDriverLabelDecorator()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)databaseDriverWidgets, constraints);
        SwitcherPanel panelSwitcher = this.buildDatabaseDriverSwitcherPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)panelSwitcher, constraints);
        JCheckBox saveUsernameCheckBox = this.buildSaveUsernameCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)saveUsernameCheckBox, constraints);
        Component usernameWidgets = this.buildUserNameWidgets();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 10, 0, 0);
        this.add(usernameWidgets, constraints);
        new ComponentEnabler((ValueModel)this.buildSaveUsernameHolder(), usernameWidgets);
        JCheckBox savePasswordCheckBox = this.buildSavePasswordCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)savePasswordCheckBox, constraints);
        Component passwordWidgets = this.buildPasswordWidgets();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 10, 0, 0);
        this.add(passwordWidgets, constraints);
        new ComponentEnabler((ValueModel)this.buildSavePasswordHolder(), passwordWidgets);
    }

    @Override
    protected void updateEnableStateOfChildren(boolean enabled) {
        super.updateEnableStateOfChildren(enabled);
        if (this.databaseSourcePane != null) {
            this.databaseSourcePane.setEnabled(enabled);
        }
        if (this.driverManagerPane != null) {
            this.driverManagerPane.setEnabled(enabled);
        }
    }

    private class LookupType {
        private String displayString;
        private Integer lookupValue;

        LookupType(String displayString, Integer lookupValue) {
            this.displayString = displayString;
            this.lookupValue = lookupValue;
        }

        public String displayString() {
            return this.displayString;
        }

        public Integer lookupValue() {
            return this.lookupValue;
        }
    }
}

