/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class PrimitiveListTreeModel
extends DefaultTreeModel {
    private ListValueModel listHolder;
    private ListChangeListener listChangeListener;

    private PrimitiveListTreeModel() {
        super(new DefaultMutableTreeNode(null, true));
        this.initialize();
    }

    public PrimitiveListTreeModel(ListValueModel listHolder) {
        this();
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
    }

    private void initialize() {
        this.listChangeListener = new PrimitiveListChangeListener();
    }

    protected abstract void primitiveChanged(int var1, Object var2);

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        int index = ((TreeNode)this.getRoot()).getIndex(node);
        this.primitiveChanged(index, newValue);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.addListChangeListener("value", this.listChangeListener);
            this.synchronizeList();
        }
        super.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.removeListChangeListener("value", this.listChangeListener);
        }
    }

    void synchronizeList() {
        this.clearList();
        this.buildList();
    }

    private void clearList() {
        int childcount = this.root.getChildCount();
        for (int i = childcount - 1; i >= 0; --i) {
            this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
        }
    }

    private void buildList() {
        Iterator stream = (Iterator)this.listHolder.getValue();
        while (stream.hasNext()) {
            this.addPrimitive(stream.next());
        }
    }

    private void addPrimitive(Object primitive) {
        this.insertPrimitive(this.root.getChildCount(), primitive);
    }

    void insertPrimitive(int index, Object primitive) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(primitive, false);
        this.insertNodeInto(node, (MutableTreeNode)this.root, index);
    }

    void removeNode(int index) {
        this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(index));
    }

    void replacePrimitive(int index, Object primitive) {
        MutableTreeNode node = (MutableTreeNode)this.root.getChildAt(index);
        node.setUserObject(primitive);
        this.nodeChanged(node);
    }

    private class PrimitiveListChangeListener
    implements ListChangeListener {
        private PrimitiveListChangeListener() {
        }

        public void itemsAdded(ListChangeEvent e) {
            int i = e.getIndex();
            ListIterator stream = e.items();
            while (stream.hasNext()) {
                PrimitiveListTreeModel.this.insertPrimitive(i++, stream.next());
            }
        }

        public void itemsRemoved(ListChangeEvent e) {
            for (int i = 0; i < e.size(); ++i) {
                PrimitiveListTreeModel.this.removeNode(e.getIndex());
            }
        }

        public void itemsReplaced(ListChangeEvent e) {
            int i = e.getIndex();
            ListIterator stream = e.items();
            while (stream.hasNext()) {
                PrimitiveListTreeModel.this.replacePrimitive(i++, stream.next());
            }
        }

        public void listChanged(ListChangeEvent e) {
            PrimitiveListTreeModel.this.synchronizeList();
        }
    }
}

