/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlSchemaRepository
extends MWModel
implements ProjectSubFileComponentContainer {
    private static final String SUB_DIRECTORY_NAME = "schemas";
    private Map schemas;
    public static final String SCHEMAS_COLLECTION = "schemas";
    private Collection schemaNames;
    private static final String SCHEMA_NAMES_COLLECTION = "schemaNames";

    private MWXmlSchemaRepository() {
    }

    public MWXmlSchemaRepository(MWXmlProject parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.schemas = new Hashtable();
        this.schemaNames = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Map map = this.schemas;
        synchronized (map) {
            children.addAll(this.schemas.values());
        }
    }

    public Iterator schemas() {
        return this.schemas.values().iterator();
    }

    public int schemasSize() {
        return this.schemas.size();
    }

    public MWXmlSchema getSchema(String schemaName) {
        return (MWXmlSchema)this.schemas.get(schemaName);
    }

    public MWXmlSchema createSchemaFromFile(String name, String file) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromFile(this, name, file));
    }

    public MWXmlSchema createSchemaFromUrl(String name, String url) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromUrl(this, name, url));
    }

    public MWXmlSchema createSchemaFromClasspath(String name, String resource) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromClasspath(this, name, resource));
    }

    private MWXmlSchema addSchema(MWXmlSchema schema) throws ResourceException {
        schema.reload();
        this.checkSchemaName(schema.getName(), schema);
        this.schemas.put(schema.getName(), schema);
        this.fireItemAdded("schemas", schema);
        return schema;
    }

    private void checkSchemaName(String schemaName, MWXmlSchema schema) {
        if (this.getSchema(schemaName) != null) {
            throw new IllegalArgumentException("Schema with name already exists.");
        }
        MWXmlSchema matchIgnoreCase = this.getSchemaIgnoreCase(schemaName);
        if (matchIgnoreCase != null && matchIgnoreCase != schema) {
            throw new IllegalArgumentException("Schema with name, but different case, already exists: \"" + matchIgnoreCase.getName() + "\".");
        }
    }

    public boolean containsSchemaIgnoreCase(String name) {
        return this.getSchemaIgnoreCase(name) != null;
    }

    public MWXmlSchema getSchemaIgnoreCase(String name) {
        for (MWXmlSchema schema : this.schemas.values()) {
            if (!schema.getName().equalsIgnoreCase(name)) continue;
            return schema;
        }
        return null;
    }

    public void removeSchema(MWXmlSchema schema) {
        if (this.getSchema(schema.getName()) == null) {
            throw new IllegalArgumentException("Schema with name does not exist.");
        }
        this.schemas.remove(schema.getName());
        this.fireItemRemoved("schemas", schema);
        this.getProject().nodeRemoved(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schemaRenamed(String oldName, String newName, MWXmlSchema schema) {
        Map map = this.schemas;
        synchronized (map) {
            this.checkSchemaName(newName, schema);
            this.schemas.put(newName, this.schemas.remove(oldName));
        }
        this.fireCollectionChanged(SCHEMA_NAMES_COLLECTION);
    }

    @Override
    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    @Override
    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
    }

    @Override
    public void descriptorUnmapped(Collection mappings) {
    }

    @Override
    public Iterator projectSubFileComponents() {
        return this.schemas();
    }

    @Override
    public void setProjectSubFileComponents(Collection subComponents) {
        this.schemas = new Hashtable(subComponents.size());
        for (MWXmlSchema schema : subComponents) {
            this.schemas.put(schema.getName(), schema);
        }
    }

    @Override
    public Iterator originalProjectSubFileComponentNames() {
        return this.schemaNames.iterator();
    }

    @Override
    public void setOriginalProjectSubFileComponentNames(Collection originalSubComponentNames) {
        this.schemaNames = originalSubComponentNames;
    }

    @Override
    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object child) {
        if (this.schemas.containsValue(child)) {
            return false;
        }
        return ((Node)child).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlSchemaRepository.class);
        XMLCompositeDirectCollectionMapping schemaNamesMapping = new XMLCompositeDirectCollectionMapping();
        schemaNamesMapping.setAttributeName(SCHEMA_NAMES_COLLECTION);
        schemaNamesMapping.setSetMethodName("setSchemaNamesForTopLink");
        schemaNamesMapping.setGetMethodName("getSchemaNamesForTopLink");
        schemaNamesMapping.useCollectionClass(HashSet.class);
        schemaNamesMapping.setXPath("schema-names/name/text()");
        descriptor.addMapping((DatabaseMapping)schemaNamesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getSchemaNamesForTopLink() {
        ArrayList names = new ArrayList(this.schemas.size());
        Map map = this.schemas;
        synchronized (map) {
            Iterator stream = this.schemas.keySet().iterator();
            while (stream.hasNext()) {
                names.add(stream.next());
            }
        }
        return CollectionTools.sort(names, (Comparator)Collator.getInstance());
    }

    private void setSchemaNamesForTopLink(Collection schemaNames) {
        this.schemaNames = schemaNames;
    }
}

