/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.EclipseLinkClassWriter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDynamicClassWriter;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ConverterAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.AbstractPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.ComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.UuidGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.jpa.weaving.RestAdapterClassWriter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Project;

public class MetadataProject {
    public static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    public static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    public static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    public static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    private boolean m_isWeavingFetchGroupsEnabled;
    private boolean m_multitenantSharedEmf;
    private boolean m_multitenantSharedCache;
    private boolean m_isWeavingEagerEnabled;
    private boolean m_isWeavingLazyEnabled;
    private boolean m_forceFieldNamesToUpperCase;
    private SharedCacheMode m_sharedCacheMode;
    private boolean m_isSharedCacheModeInitialized = false;
    private MetadataProcessor m_compositeProcessor;
    private PersistenceUnitInfo m_persistenceUnitInfo;
    private AbstractSession m_session;
    private MetadataLogger m_logger;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;
    private List<RelationshipAccessor> m_owningRelationshipAccessors;
    private List<RelationshipAccessor> m_nonOwningRelationshipAccessors;
    private List<MappingAccessor> m_embeddableMappingAccessors;
    private List<DirectCollectionAccessor> m_directCollectionAccessors;
    private List<ClassAccessor> m_accessorsWithCustomizer;
    private Map<String, XMLEntityMappings> m_entityMappings;
    private Map<String, MappedSuperclassAccessor> m_mappedSuperclasseAccessors;
    private Map<String, ClassAccessor> m_allAccessors;
    private Map<String, EntityAccessor> m_entityAccessors;
    private Map<String, ClassAccessor> m_virtualClasses;
    private Map<String, EmbeddableAccessor> m_embeddableAccessors;
    private Map<String, EmbeddableAccessor> m_rootEmbeddableAccessors;
    private Map<String, InterfaceAccessor> m_interfaceAccessors;
    private Map<String, ClassAccessor> m_accessorsWithDerivedId;
    private Map<String, NamedQueryMetadata> m_queries;
    private Map<String, SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private Map<MetadataClass, GeneratedValueMetadata> m_generatedValues;
    private Map<String, TableGeneratorMetadata> m_tableGenerators;
    private Map<String, SequenceGeneratorMetadata> m_sequenceGenerators;
    private Map<String, UuidGeneratorMetadata> m_uuidGenerators;
    private Map<String, AbstractConverterMetadata> m_converters;
    private Map<String, ConverterAccessor> m_converterAccessors;
    private Map<MetadataClass, ConverterAccessor> m_autoApplyConvertAccessors;
    private Map<String, ComplexTypeMetadata> m_complexMetadataTypes;
    private Map<String, AbstractPartitioningMetadata> m_partitioningPolicies;
    private Map<String, MappedSuperclassAccessor> m_metamodelMappedSuperclasses;
    private Set<String> m_idClasses;
    private Set<String> m_interfacesImplementedByEntities;
    private Set<EntityListenerMetadata> m_defaultListeners;

    public void createRestInterfaces(ClassLoader loader) {
        if (DynamicClassLoader.class.isAssignableFrom(loader.getClass())) {
            DynamicClassLoader dcl = (DynamicClassLoader)loader;
            for (EntityAccessor accessor : this.getEntityAccessors()) {
                String className = accessor.getParentClassName();
                if (className != null && this.getEntityAccessor(className) != null) continue;
                RestAdapterClassWriter restAdapter = new RestAdapterClassWriter(accessor.getJavaClassName());
                dcl.addClass(restAdapter.getClassName(), (EclipseLinkClassWriter)restAdapter);
            }
        }
    }

    public MetadataProject(PersistenceUnitInfo puInfo, AbstractSession session, boolean weaveLazy, boolean weaveEager, boolean weaveFetchGroups, boolean multitenantSharedEmf, boolean multitenantSharedCache) {
        this.m_persistenceUnitInfo = puInfo;
        this.m_session = session;
        this.m_logger = new MetadataLogger(session);
        this.m_isWeavingEagerEnabled = weaveEager;
        this.m_isWeavingLazyEnabled = weaveLazy;
        this.m_isWeavingFetchGroupsEnabled = weaveFetchGroups;
        this.m_multitenantSharedEmf = multitenantSharedEmf;
        this.m_multitenantSharedCache = multitenantSharedCache;
        this.m_owningRelationshipAccessors = new ArrayList<RelationshipAccessor>();
        this.m_nonOwningRelationshipAccessors = new ArrayList<RelationshipAccessor>();
        this.m_embeddableMappingAccessors = new ArrayList<MappingAccessor>();
        this.m_directCollectionAccessors = new ArrayList<DirectCollectionAccessor>();
        this.m_accessorsWithCustomizer = new ArrayList<ClassAccessor>();
        this.m_entityMappings = new LinkedHashMap<String, XMLEntityMappings>();
        this.m_defaultListeners = new LinkedHashSet<EntityListenerMetadata>();
        this.m_queries = new HashMap<String, NamedQueryMetadata>();
        this.m_sqlResultSetMappings = new HashMap<String, SQLResultSetMappingMetadata>();
        this.m_allAccessors = new HashMap<String, ClassAccessor>();
        this.m_entityAccessors = new HashMap<String, EntityAccessor>();
        this.m_embeddableAccessors = new HashMap<String, EmbeddableAccessor>();
        this.m_rootEmbeddableAccessors = new HashMap<String, EmbeddableAccessor>();
        this.m_interfaceAccessors = new HashMap<String, InterfaceAccessor>();
        this.m_mappedSuperclasseAccessors = new HashMap<String, MappedSuperclassAccessor>();
        this.m_generatedValues = new HashMap<MetadataClass, GeneratedValueMetadata>();
        this.m_tableGenerators = new HashMap<String, TableGeneratorMetadata>();
        this.m_sequenceGenerators = new HashMap<String, SequenceGeneratorMetadata>();
        this.m_uuidGenerators = new HashMap<String, UuidGeneratorMetadata>();
        this.m_converters = new HashMap<String, AbstractConverterMetadata>();
        this.m_converterAccessors = new HashMap<String, ConverterAccessor>();
        this.m_autoApplyConvertAccessors = new HashMap<MetadataClass, ConverterAccessor>();
        this.m_partitioningPolicies = new HashMap<String, AbstractPartitioningMetadata>();
        this.m_complexMetadataTypes = new HashMap<String, ComplexTypeMetadata>();
        this.m_metamodelMappedSuperclasses = new HashMap<String, MappedSuperclassAccessor>();
        this.m_virtualClasses = new HashMap<String, ClassAccessor>();
        this.m_accessorsWithDerivedId = new HashMap<String, ClassAccessor>();
        this.m_idClasses = new HashSet<String>();
        this.m_interfacesImplementedByEntities = new HashSet<String>();
    }

    protected void addAccessor(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        this.processPersistenceUnitMetadata(descriptor);
        accessor.processParentClass();
        this.m_session.getProject().addDescriptor(descriptor.getClassDescriptor());
        this.m_allAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addAccessorWithCustomizer(ClassAccessor accessor) {
        this.m_accessorsWithCustomizer.add(accessor);
    }

    public void addAccessorWithDerivedId(ClassAccessor accessor) {
        this.m_accessorsWithDerivedId.put(accessor.getJavaClassName(), accessor);
    }

    public void addAlias(String alias, MetadataDescriptor descriptor) {
        ClassDescriptor existingDescriptor = this.m_session.getProject().getDescriptorForAlias(alias);
        if (existingDescriptor != null) {
            throw ValidationException.nonUniqueEntityName((String)existingDescriptor.getJavaClassName(), (String)descriptor.getJavaClassName(), (String)alias);
        }
        descriptor.setAlias(alias);
        this.m_session.getProject().addAlias(alias, descriptor.getClassDescriptor());
    }

    public void addConverter(AbstractConverterMetadata converter) {
        if (converter.shouldOverride(this.m_converters.get(converter.getName()))) {
            this.m_converters.put(converter.getName(), converter);
        }
    }

    public void addConverterAccessor(ConverterAccessor converterAccessor) {
        if (converterAccessor.shouldOverride(this.m_converterAccessors.get(converterAccessor.getIdentifier()))) {
            this.m_converterAccessors.put(converterAccessor.getIdentifier(), converterAccessor);
        }
    }

    public void addDefaultListener(EntityListenerMetadata defaultListener) {
        this.m_defaultListeners.add(defaultListener);
    }

    public void addDirectCollectionAccessor(MappingAccessor accessor) {
        this.m_directCollectionAccessors.add((DirectCollectionAccessor)accessor);
    }

    public void addEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.addAccessor(accessor);
        accessor.getDescriptor().setIsEmbeddable();
        this.m_embeddableAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEmbeddableMappingAccessor(MappingAccessor accessor) {
        this.m_embeddableMappingAccessors.add(accessor);
    }

    public void addEntityAccessor(EntityAccessor accessor) {
        this.addAccessor(accessor);
        this.m_interfacesImplementedByEntities.addAll(accessor.getJavaClass().getInterfaces());
        this.m_entityAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEntityGraph(AttributeGroup entityGraph) {
        this.getProject().getAttributeGroups().put(entityGraph.getName(), entityGraph);
    }

    public void addEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings.put(entityMappings.getMappingFileOrURL(), entityMappings);
    }

    public void addGeneratedValue(GeneratedValueMetadata generatedvalue, MetadataClass entityClass) {
        this.m_generatedValues.put(entityClass, generatedvalue);
    }

    public void addIdClass(String idClassName) {
        this.m_idClasses.add(idClassName);
    }

    public void addInterfaceAccessor(InterfaceAccessor accessor) {
        this.m_interfaceAccessors.put(accessor.getJavaClassName(), accessor);
        this.m_session.getProject().addDescriptor(accessor.getDescriptor().getClassDescriptor());
    }

    public void addMappedSuperclass(MappedSuperclassAccessor mappedSuperclass) {
        mappedSuperclass.processParentClass();
        this.m_mappedSuperclasseAccessors.put(mappedSuperclass.getJavaClassName(), mappedSuperclass);
        this.m_session.getProject().addMappedSuperclass(mappedSuperclass.getJavaClassName(), mappedSuperclass.getDescriptor().getClassDescriptor(), false);
    }

    public void addMetamodelMappedSuperclass(MappedSuperclassAccessor accessor, MetadataDescriptor childDescriptor) {
        if (!this.m_metamodelMappedSuperclasses.containsKey(accessor.getJavaClassName())) {
            MetadataDescriptor metadataDescriptor = accessor.getDescriptor();
            metadataDescriptor.setMetamodelMappedSuperclassChildDescriptor(childDescriptor);
            metadataDescriptor.setClassAccessor(accessor);
            this.processPersistenceUnitMetadata(metadataDescriptor);
            if (accessor.getEntityMappings() != null) {
                accessor.getEntityMappings().processEntityMappingsDefaults(accessor);
            }
            accessor.processAccessType();
            accessor.addAccessors();
            this.m_metamodelMappedSuperclasses.put(accessor.getJavaClassName(), accessor);
            metadataDescriptor.setPrimaryTable(new DatabaseTable("__METAMODEL_RESERVED_IN_MEM_ONLY_TABLE_NAME"));
            if (!metadataDescriptor.hasIdAccessor() && !metadataDescriptor.hasEmbeddedId()) {
                DatabaseField pkField = new DatabaseField("__PK_METAMODEL_RESERVED_IN_MEM_ONLY_FIELD_NAME");
                if (this.useDelimitedIdentifier()) {
                    pkField.setUseDelimiters(true);
                } else if (this.getShouldForceFieldNamesToUpperCase()) {
                    pkField.useUpperCaseForComparisons(true);
                }
                metadataDescriptor.addPrimaryKeyField(pkField);
            }
            this.m_session.getProject().addMappedSuperclass(accessor.getJavaClassName(), metadataDescriptor.getClassDescriptor(), true);
        }
    }

    public void addPartitioningPolicy(AbstractPartitioningMetadata policy) {
        if (policy.shouldOverride(this.m_partitioningPolicies.get(policy.getName()))) {
            this.m_partitioningPolicies.put(policy.getName(), policy);
        }
    }

    public void addComplexMetadataType(ComplexTypeMetadata type) {
        if (type.shouldOverride(this.m_complexMetadataTypes.get(type.getName()))) {
            this.m_complexMetadataTypes.put(type.getName(), type);
        }
    }

    public void addQuery(NamedQueryMetadata query) {
        if (query.shouldOverride(this.m_queries.get(query.getName()))) {
            this.m_queries.put(query.getName(), query);
        }
    }

    public void addRelationshipAccessor(RelationshipAccessor accessor) {
        if (accessor.hasMappedBy()) {
            this.m_nonOwningRelationshipAccessors.add(accessor);
        } else {
            this.m_owningRelationshipAccessors.add(accessor);
        }
    }

    public void addRootEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.m_rootEmbeddableAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator, String defaultCatalog, String defaultSchema) {
        String name = sequenceGenerator.getName();
        if (name.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_TABLE_GENERATOR, (Object)sequenceGenerator.getLocation());
        }
        if (name.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)sequenceGenerator.getLocation());
        }
        sequenceGenerator.setCatalog(MetadataHelper.getName(sequenceGenerator.getCatalog(), defaultCatalog, sequenceGenerator.getCatalogContext(), this.m_logger, sequenceGenerator.getLocation()));
        sequenceGenerator.setSchema(MetadataHelper.getName(sequenceGenerator.getSchema(), defaultSchema, sequenceGenerator.getSchemaContext(), this.m_logger, sequenceGenerator.getLocation()));
        TableGeneratorMetadata tableGenerator = this.m_tableGenerators.get(name);
        if (tableGenerator != null) {
            if (sequenceGenerator.shouldOverride(tableGenerator)) {
                this.m_tableGenerators.remove(name);
            } else {
                throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)name, (Object)sequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
            }
        }
        for (TableGeneratorMetadata otherTableGenerator : this.m_tableGenerators.values()) {
            if (tableGenerator == otherTableGenerator || otherTableGenerator.getPkColumnValue() == null || !otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName()) || otherTableGenerator.getPkColumnValue().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (Object)sequenceGenerator.getLocation(), (Object)otherTableGenerator.getLocation());
        }
        if (sequenceGenerator.shouldOverride(this.m_sequenceGenerators.get(name))) {
            this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
        }
    }

    public void addUuidGenerator(UuidGeneratorMetadata uuidGenerator) {
        String name = uuidGenerator.getName();
        TableGeneratorMetadata tableGenerator = this.m_tableGenerators.get(name);
        if (tableGenerator != null) {
            if (uuidGenerator.shouldOverride(tableGenerator)) {
                this.m_tableGenerators.remove(name);
            } else {
                throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)name, (Object)uuidGenerator.getLocation(), (Object)tableGenerator.getLocation());
            }
        }
        this.m_uuidGenerators.put(uuidGenerator.getName(), uuidGenerator);
    }

    public void addSQLResultSetMapping(SQLResultSetMappingMetadata sqlResultSetMapping) {
        if (sqlResultSetMapping.shouldOverride(this.m_sqlResultSetMappings.get(sqlResultSetMapping.getName()))) {
            this.m_sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
        }
    }

    public void addStaticMetamodelClass(MetadataAnnotation annotation, MetadataClass metamodelClass) {
        MetadataClass modelClass = metamodelClass.getMetadataClass(annotation.getAttributeString("value"));
        this.m_session.addStaticMetamodelClass(modelClass.getName(), metamodelClass.getName());
    }

    public void addTableGenerator(TableGeneratorMetadata tableGenerator, String defaultCatalog, String defaultSchema) {
        this.processTable(tableGenerator, "", defaultCatalog, defaultSchema, tableGenerator);
        String generatorName = tableGenerator.getGeneratorName();
        if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_SEQUENCE_GENERATOR, (Object)tableGenerator.getLocation());
        }
        if (generatorName.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)tableGenerator.getLocation());
        }
        SequenceGeneratorMetadata otherSequenceGenerator = this.m_sequenceGenerators.get(generatorName);
        if (otherSequenceGenerator != null) {
            if (tableGenerator.shouldOverride(otherSequenceGenerator)) {
                this.m_sequenceGenerators.remove(generatorName);
            } else {
                throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)generatorName, (Object)otherSequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
            }
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
            if (otherSequenceGenerator == sequenceGenerator || sequenceGenerator.getSequenceName() == null || !sequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue()) || sequenceGenerator.getSequenceName().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (Object)sequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
        }
        if (tableGenerator.shouldOverride(this.m_tableGenerators.get(generatorName))) {
            this.m_tableGenerators.put(generatorName, tableGenerator);
        }
    }

    public void addVirtualClass(ClassAccessor accessor) {
        this.m_virtualClasses.put(accessor.getJavaClassName(), accessor);
    }

    protected void createDynamicClass(MetadataDescriptor descriptor, Map<String, MetadataDescriptor> virtualEntities, DynamicClassLoader dcl) {
        if (!virtualEntities.containsKey(descriptor.getJavaClassName())) {
            if (descriptor.isInheritanceSubclass()) {
                MetadataDescriptor parentDescriptor = descriptor.getInheritanceParentDescriptor();
                this.createDynamicClass(parentDescriptor, virtualEntities, dcl);
                descriptor.getClassDescriptor().setJavaClass(dcl.createDynamicClass(descriptor.getJavaClassName(), parentDescriptor.getClassDescriptor().getJavaClass()));
            } else {
                descriptor.getClassDescriptor().setJavaClass(dcl.createDynamicClass(descriptor.getJavaClassName(), (DynamicClassWriter)new MetadataDynamicClassWriter(descriptor)));
            }
            virtualEntities.put(descriptor.getJavaClassName(), descriptor);
        }
    }

    public void createDynamicClasses(ClassLoader loader) {
        if (!this.m_virtualClasses.isEmpty()) {
            if (DynamicClassLoader.class.isAssignableFrom(loader.getClass())) {
                DynamicClassLoader dcl = (DynamicClassLoader)loader;
                HashMap<String, MetadataDescriptor> dynamicClasses = new HashMap<String, MetadataDescriptor>();
                for (ClassAccessor accessor : this.m_virtualClasses.values()) {
                    this.createDynamicClass(accessor.getDescriptor(), dynamicClasses, dcl);
                }
                HashMap<String, DynamicType> dynamicTypes = new HashMap<String, DynamicType>();
                for (MetadataDescriptor descriptor : dynamicClasses.values()) {
                    this.createDynamicType(descriptor, dynamicTypes, dcl);
                }
            } else {
                throw ValidationException.invalidClassLoaderForDynamicPersistence();
            }
        }
    }

    protected void createDynamicType(MetadataDescriptor descriptor, Map<String, DynamicType> dynamicTypes, DynamicClassLoader dcl) {
        if (!dynamicTypes.containsKey(descriptor.getJavaClassName())) {
            JPADynamicTypeBuilder typeBuilder = null;
            if (descriptor.isInheritanceSubclass()) {
                MetadataDescriptor parentDescriptor = descriptor.getInheritanceParentDescriptor();
                this.createDynamicType(parentDescriptor, dynamicTypes, dcl);
                typeBuilder = new JPADynamicTypeBuilder(dcl, descriptor.getClassDescriptor(), dynamicTypes.get(parentDescriptor.getJavaClassName()));
            } else {
                typeBuilder = new JPADynamicTypeBuilder(dcl, descriptor.getClassDescriptor(), null);
            }
            dynamicTypes.put(descriptor.getJavaClassName(), typeBuilder.getType());
        }
    }

    public void disableWeaving() {
        this.m_isWeavingLazyEnabled = false;
        this.m_isWeavingEagerEnabled = false;
        this.m_isWeavingFetchGroupsEnabled = false;
    }

    public boolean excludeDefaultMappings() {
        if (this.m_persistenceUnitMetadata != null) {
            return this.m_persistenceUnitMetadata.excludeDefaultMappings();
        }
        return false;
    }

    public ClassAccessor getAccessor(String className) {
        return this.m_allAccessors.get(className);
    }

    public List<ClassAccessor> getAccessorsWithCustomizer() {
        return this.m_accessorsWithCustomizer;
    }

    public Collection<ClassAccessor> getAllAccessors() {
        return this.m_allAccessors.values();
    }

    public ConverterAccessor getAutoApplyConverter(MetadataClass cls) {
        return this.m_autoApplyConvertAccessors.get(cls);
    }

    public MetadataProcessor getCompositeProcessor() {
        return this.m_compositeProcessor;
    }

    public AbstractConverterMetadata getConverter(String name) {
        return this.m_converters.get(name);
    }

    public ConverterAccessor getConverterAccessor(MetadataClass cls) {
        return this.m_converterAccessors.get(cls.getName());
    }

    public Map<String, ConverterAccessor> getConverterAccessors() {
        return this.m_converterAccessors;
    }

    public Set<EntityListenerMetadata> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public EmbeddableAccessor getEmbeddableAccessor(MetadataClass cls) {
        return this.getEmbeddableAccessor(cls, false);
    }

    public EmbeddableAccessor getEmbeddableAccessor(MetadataClass cls, boolean checkIsIdClass) {
        EmbeddableAccessor accessor = this.m_embeddableAccessors.get(cls.getName());
        if (accessor == null && (cls.isAnnotationPresent("javax.persistence.Embeddable") || checkIsIdClass && this.isIdClass(cls))) {
            accessor = new EmbeddableAccessor(cls.getAnnotation("javax.persistence.Embeddable"), cls, this);
            this.addEmbeddableAccessor(accessor);
        }
        return accessor;
    }

    public EmbeddableAccessor getEmbeddableAccessor(String className) {
        return this.m_embeddableAccessors.get(className);
    }

    public Collection<EmbeddableAccessor> getEmbeddableAccessors() {
        return this.m_embeddableAccessors.values();
    }

    public EntityAccessor getEntityAccessor(MetadataClass cls) {
        return this.getEntityAccessor(cls.getName());
    }

    public EntityAccessor getEntityAccessor(String className) {
        return this.m_entityAccessors.get(className);
    }

    public Collection<EntityAccessor> getEntityAccessors() {
        return this.m_entityAccessors.values();
    }

    public Collection<XMLEntityMappings> getEntityMappings() {
        return this.m_entityMappings.values();
    }

    public InterfaceAccessor getInterfaceAccessor(String className) {
        return this.m_interfaceAccessors.get(className);
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MappedSuperclassAccessor getMappedSuperclassAccessor(MetadataClass cls) {
        return this.getMappedSuperclassAccessor(cls.getName());
    }

    public MappedSuperclassAccessor getMappedSuperclassAccessor(String className) {
        return this.m_mappedSuperclasseAccessors.get(className);
    }

    public Collection<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasseAccessors.values();
    }

    public Collection<MappedSuperclassAccessor> getMetamodelMappedSuperclasses() {
        return this.m_metamodelMappedSuperclasses.values();
    }

    public AbstractPartitioningMetadata getPartitioningPolicy(String name) {
        return this.m_partitioningPolicies.get(name);
    }

    protected String getPersistenceUnitDefaultCatalog() {
        if (this.m_persistenceUnitMetadata != null) {
            return this.m_persistenceUnitMetadata.getCatalog();
        }
        return null;
    }

    protected String getPersistenceUnitDefaultSchema() {
        if (this.m_persistenceUnitMetadata != null) {
            return this.m_persistenceUnitMetadata.getSchema();
        }
        return null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.m_persistenceUnitInfo;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public ComplexTypeMetadata getComplexTypeMetadata(String name) {
        return this.m_complexMetadataTypes.get(name);
    }

    public Project getProject() {
        return this.m_session.getProject();
    }

    public Collection<EmbeddableAccessor> getRootEmbeddableAccessors() {
        return this.m_rootEmbeddableAccessors.values();
    }

    public AbstractSession getSession() {
        return this.m_session;
    }

    protected String getSharedCacheModeName() {
        if (!this.m_isSharedCacheModeInitialized) {
            try {
                Method method = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getSharedCacheMode", null));
                    this.m_sharedCacheMode = (SharedCacheMode)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, (Object)this.m_persistenceUnitInfo));
                } else {
                    method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, (String)"getSharedCacheMode", null);
                    this.m_sharedCacheMode = (SharedCacheMode)PrivilegedAccessHelper.invokeMethod((Method)method, (Object)this.m_persistenceUnitInfo, null);
                }
            }
            catch (Throwable throwable) {
                this.m_sharedCacheMode = null;
            }
            this.m_isSharedCacheModeInitialized = true;
        }
        return this.m_sharedCacheMode == null ? null : this.m_sharedCacheMode.name();
    }

    public boolean getShouldForceFieldNamesToUpperCase() {
        return this.m_forceFieldNamesToUpperCase;
    }

    public List<StructConverterMetadata> getStructConverters() {
        ArrayList<StructConverterMetadata> structConverters = new ArrayList<StructConverterMetadata>();
        for (AbstractConverterMetadata converter : this.m_converters.values()) {
            if (!converter.isStructConverter()) continue;
            structConverters.add((StructConverterMetadata)converter);
        }
        return structConverters;
    }

    public Collection<String> getWeavableClassNames() {
        return Collections.unmodifiableCollection(this.m_allAccessors.keySet());
    }

    public boolean hasAutoApplyConverter(MetadataClass cls) {
        return this.m_autoApplyConvertAccessors.containsKey(cls);
    }

    public boolean hasConverter(String name) {
        return this.m_converters.containsKey(name);
    }

    public boolean hasConverterAccessor(MetadataClass cls) {
        return this.m_converterAccessors.containsKey(cls.getName());
    }

    public boolean hasEmbeddable(MetadataClass cls) {
        return this.hasEmbeddable(cls.getName());
    }

    public boolean hasEmbeddable(String className) {
        return this.m_embeddableAccessors.containsKey(className);
    }

    public boolean hasEntity(MetadataClass cls) {
        return this.hasEntity(cls.getName());
    }

    public boolean hasEntity(String className) {
        return this.m_entityAccessors.containsKey(className);
    }

    public boolean hasEntityGraph(String name) {
        return this.getProject().getAttributeGroups().containsKey(name);
    }

    public boolean hasEntityThatImplementsInterface(String interfaceName) {
        return this.m_interfacesImplementedByEntities.contains(interfaceName);
    }

    public boolean hasInterface(MetadataClass cls) {
        return this.m_interfaceAccessors.containsKey(cls.getName());
    }

    public boolean hasMappedSuperclass(MetadataClass cls) {
        return this.hasMappedSuperclass(cls.getName());
    }

    public boolean hasMappedSuperclass(String className) {
        return this.m_mappedSuperclasseAccessors.containsKey(className);
    }

    public boolean hasSharedCacheMode() {
        return this.getSharedCacheModeName() != null;
    }

    public boolean isIdClass(MetadataClass idClass) {
        return this.m_idClasses.contains(idClass.getName());
    }

    public boolean isSharedCacheModeAll() {
        return this.hasSharedCacheMode() && this.getSharedCacheModeName().equals(SharedCacheMode.ALL.name());
    }

    public boolean isSharedCacheModeDisableSelective() {
        return !this.hasSharedCacheMode() || this.getSharedCacheModeName().equals(SharedCacheMode.DISABLE_SELECTIVE.name());
    }

    public boolean isSharedCacheModeEnableSelective() {
        return this.hasSharedCacheMode() && this.getSharedCacheModeName().equals(SharedCacheMode.ENABLE_SELECTIVE.name());
    }

    public boolean isSharedCacheModeNone() {
        return this.hasSharedCacheMode() && this.getSharedCacheModeName().equals(SharedCacheMode.NONE.name());
    }

    public boolean isSharedCacheModeUnspecified() {
        return this.hasSharedCacheMode() && this.getSharedCacheModeName().equals(SharedCacheMode.UNSPECIFIED.name());
    }

    public boolean isWeavingEagerEnabled() {
        return this.m_isWeavingEagerEnabled;
    }

    public boolean isWeavingFetchGroupsEnabled() {
        return this.m_isWeavingFetchGroupsEnabled;
    }

    public boolean isWeavingLazyEnabled() {
        return this.m_isWeavingLazyEnabled;
    }

    public boolean isXMLMappingMetadataComplete() {
        if (this.m_persistenceUnitMetadata != null) {
            return this.m_persistenceUnitMetadata.isXMLMappingMetadataComplete();
        }
        return false;
    }

    protected void processEmbeddableMappingAccessors() {
        for (MappingAccessor mappingAccessor : this.m_embeddableMappingAccessors) {
            if (mappingAccessor.isProcessed()) continue;
            mappingAccessor.process();
        }
    }

    protected void processAccessorsWithDerivedIDs() {
        HashSet<ClassAccessor> processed = new HashSet<ClassAccessor>();
        HashSet<ClassAccessor> processing = new HashSet<ClassAccessor>();
        for (ClassAccessor classAccessor : this.m_accessorsWithDerivedId.values()) {
            classAccessor.processDerivedId(processing, processed);
        }
    }

    public void processDirectCollectionAccessors() {
        for (DirectCollectionAccessor accessor : this.m_directCollectionAccessors) {
            accessor.process();
        }
    }

    protected void processInterfaceAccessors() {
        for (EntityAccessor accessor : this.getEntityAccessors()) {
            for (String interfaceClass : accessor.getJavaClass().getInterfaces()) {
                if (!this.m_interfaceAccessors.containsKey(interfaceClass)) continue;
                this.m_interfaceAccessors.get(interfaceClass).addEntityAccessor(accessor);
            }
        }
    }

    protected void processNonOwningRelationshipAccessors() {
        for (RelationshipAccessor accessor : this.m_nonOwningRelationshipAccessors) {
            if (accessor.isProcessed()) continue;
            accessor.process();
        }
    }

    protected void processOwningRelationshipAccessors() {
        for (RelationshipAccessor accessor : this.m_owningRelationshipAccessors) {
            if (accessor.isProcessed()) continue;
            accessor.process();
        }
    }

    protected void processPersistenceUnitMetadata(MetadataDescriptor descriptor) {
        XMLPersistenceUnitDefaults persistenceUnitDefaults;
        if (this.m_persistenceUnitMetadata != null && (persistenceUnitDefaults = this.m_persistenceUnitMetadata.getPersistenceUnitDefaults()) != null) {
            descriptor.setDefaultAccess(persistenceUnitDefaults.getAccess());
            descriptor.setDefaultSchema(persistenceUnitDefaults.getSchema());
            descriptor.setDefaultCatalog(persistenceUnitDefaults.getCatalog());
            descriptor.setDefaultTenantDiscriminatorColumns(persistenceUnitDefaults.getTenantDiscriminatorColumns());
            descriptor.setIsCascadePersist(persistenceUnitDefaults.isCascadePersist());
            if (persistenceUnitDefaults.hasAccessMethods()) {
                descriptor.setDefaultAccessMethods(persistenceUnitDefaults.getAccessMethods());
            }
        }
    }

    public void processQueries() {
        for (SQLResultSetMappingMetadata sqlResultSetMapping : this.m_sqlResultSetMappings.values()) {
            this.m_session.getProject().addSQLResultSetMapping(sqlResultSetMapping.process());
        }
        for (NamedQueryMetadata query : this.m_queries.values()) {
            query.process(this.m_session);
        }
    }

    protected void processSequencingAccessors() {
        if (!this.m_generatedValues.isEmpty()) {
            Hashtable<String, Sequence> sequences = new Hashtable<String, Sequence>();
            for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
                sequences.put(sequenceGenerator.getName(), (Sequence)sequenceGenerator.process(this.m_logger));
            }
            for (UuidGeneratorMetadata uuidGenerator : this.m_uuidGenerators.values()) {
                sequences.put(uuidGenerator.getName(), (Sequence)uuidGenerator.process(this.m_logger));
            }
            for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators.values()) {
                sequences.put(tableGenerator.getGeneratorName(), (Sequence)tableGenerator.process(this.m_logger));
            }
            if (!sequences.containsKey(DEFAULT_TABLE_GENERATOR)) {
                TableGeneratorMetadata tableGenerator;
                tableGenerator = new TableGeneratorMetadata(DEFAULT_TABLE_GENERATOR);
                String defaultTableGeneratorName = "";
                this.processTable(tableGenerator, defaultTableGeneratorName, this.getPersistenceUnitDefaultCatalog(), this.getPersistenceUnitDefaultSchema(), tableGenerator);
                sequences.put(DEFAULT_TABLE_GENERATOR, (Sequence)tableGenerator.process(this.m_logger));
            }
            if (!sequences.containsKey(DEFAULT_SEQUENCE_GENERATOR)) {
                sequences.put(DEFAULT_SEQUENCE_GENERATOR, (Sequence)new SequenceGeneratorMetadata(DEFAULT_SEQUENCE_GENERATOR, this.getPersistenceUnitDefaultCatalog(), this.getPersistenceUnitDefaultSchema()).process(this.m_logger));
            }
            if (!sequences.containsKey(DEFAULT_IDENTITY_GENERATOR)) {
                sequences.put(DEFAULT_IDENTITY_GENERATOR, (Sequence)new SequenceGeneratorMetadata(DEFAULT_IDENTITY_GENERATOR, 1, this.getPersistenceUnitDefaultCatalog(), this.getPersistenceUnitDefaultSchema(), true).process(this.m_logger));
            }
            SequenceGeneratorMetadata tempGenerator = new SequenceGeneratorMetadata(DEFAULT_AUTO_GENERATOR, this.getPersistenceUnitDefaultCatalog(), this.getPersistenceUnitDefaultSchema());
            DatabaseLogin login = this.m_session.getProject().getLogin();
            login.setTableQualifier(tempGenerator.processQualifier());
            for (MetadataClass entityClass : this.m_generatedValues.keySet()) {
                ClassAccessor accessor = this.m_allAccessors.get(entityClass.getName());
                if (accessor == null) continue;
                this.m_generatedValues.get(entityClass).process(accessor.getDescriptor(), sequences, (DatasourceLogin)login);
            }
        }
    }

    protected void processPartitioning() {
        for (AbstractPartitioningMetadata metadata : this.m_partitioningPolicies.values()) {
            this.m_session.getProject().addPartitioningPolicy(metadata.buildPolicy());
        }
    }

    public void processStage1() {
        for (EntityAccessor entity : this.getEntityAccessors()) {
            if (entity.isPreProcessed()) continue;
            entity.preProcess();
        }
        for (EmbeddableAccessor embeddable : this.getRootEmbeddableAccessors()) {
            if (embeddable.isPreProcessed()) continue;
            embeddable.preProcess();
        }
        for (ConverterAccessor converterAccessor : this.getConverterAccessors().values()) {
            if (!converterAccessor.autoApply()) continue;
            this.m_autoApplyConvertAccessors.put(converterAccessor.getAttributeClassification(), converterAccessor);
        }
        for (EmbeddableAccessor embeddable : this.getEmbeddableAccessors()) {
            if (embeddable.isPreProcessed()) continue;
            embeddable.preProcess();
        }
    }

    public void processStage2() {
        for (MappedSuperclassAccessor msAccessor : this.m_metamodelMappedSuperclasses.values()) {
            if (msAccessor.isProcessed()) continue;
            msAccessor.processMetamodelDescriptor();
        }
        for (EntityAccessor entity : this.getEntityAccessors()) {
            if (entity.isProcessed()) continue;
            entity.process();
        }
        for (EmbeddableAccessor embeddable : this.getEmbeddableAccessors()) {
            if (embeddable.isProcessed()) continue;
            embeddable.process();
        }
    }

    public void processStage3(PersistenceUnitProcessor.Mode mode) {
        if (mode == PersistenceUnitProcessor.Mode.ALL || mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE) {
            this.processAccessorsWithDerivedIDs();
            this.processDirectCollectionAccessors();
            this.processSequencingAccessors();
            this.processOwningRelationshipAccessors();
            this.processEmbeddableMappingAccessors();
            if (this.getCompositeProcessor() != null) {
                for (EmbeddableAccessor accessor : this.getEmbeddableAccessors()) {
                    if (accessor.isProcessed()) continue;
                    accessor.process();
                }
            }
        }
        if (mode == PersistenceUnitProcessor.Mode.ALL || mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_FINAL) {
            this.processNonOwningRelationshipAccessors();
            this.processInterfaceAccessors();
            this.processPartitioning();
        }
    }

    public void processTable(TableMetadata table, String defaultName, String defaultCatalog, String defaultSchema, ORMetadata owner) {
        String name = MetadataHelper.getName(table.getName(), defaultName, table.getNameContext(), this.m_logger, owner.getAccessibleObject());
        String catalog = MetadataHelper.getName(table.getCatalog(), defaultCatalog, table.getCatalogContext(), this.m_logger, owner.getAccessibleObject());
        String schema = MetadataHelper.getName(table.getSchema(), defaultSchema, table.getSchemaContext(), this.m_logger, owner.getAccessibleObject());
        String tableName = new String(name);
        if (!schema.equals("")) {
            tableName = String.valueOf(schema) + "." + tableName;
        }
        if (!catalog.equals("")) {
            tableName = String.valueOf(catalog) + "." + tableName;
        }
        table.setFullyQualifiedTableName(tableName);
        if (this.useDelimitedIdentifier()) {
            table.setUseDelimiters(this.useDelimitedIdentifier());
        }
        table.processUniqueConstraints();
        table.processIndexes();
        table.processForeignKey();
        table.processCreationSuffix();
    }

    public void removeEmbeddableAccessor(MetadataClass metadataClass) {
        this.m_allAccessors.remove(metadataClass.getName());
        this.m_embeddableAccessors.remove(metadataClass.getName());
    }

    public void removeEntityAccessor(MetadataClass metadataClass) {
        this.m_allAccessors.remove(metadataClass.getName());
        this.m_entityAccessors.remove(metadataClass.getName());
    }

    public void removeMappedSuperclassAccessor(MetadataClass metadataClass) {
        this.m_mappedSuperclasseAccessors.remove(metadataClass.getName());
    }

    public void setAllowNativeSQLQueries(boolean allowNativeSQLQueries) {
        this.getProject().setAllowNativeSQLQueries(allowNativeSQLQueries);
    }

    public void setCompositeProcessor(MetadataProcessor compositeProcessor) {
        this.m_compositeProcessor = compositeProcessor;
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        if (this.m_persistenceUnitMetadata == null) {
            this.m_persistenceUnitMetadata = persistenceUnitMetadata;
        } else {
            this.m_persistenceUnitMetadata.merge(persistenceUnitMetadata);
        }
    }

    public void setShouldForceFieldNamesToUpperCase(boolean shouldForceFieldNamesToUpperCase) {
        this.m_forceFieldNamesToUpperCase = shouldForceFieldNamesToUpperCase;
    }

    public String toString() {
        return "Project[" + this.getPersistenceUnitInfo().getPersistenceUnitName() + "]";
    }

    public boolean useDelimitedIdentifier() {
        return this.m_persistenceUnitMetadata != null && this.m_persistenceUnitMetadata.isDelimitedIdentifiers();
    }

    public boolean usesMultitenantSharedCache() {
        return this.m_multitenantSharedCache;
    }

    public boolean usesMultitenantSharedEmf() {
        return this.m_multitenantSharedEmf;
    }

    public boolean hasVirtualClasses() {
        return this.m_virtualClasses != null && !this.m_virtualClasses.isEmpty();
    }
}

