/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.bson.BSONException;
import org.bson.io.PoolOutputBuffer;

public class BSONByteBuffer {
    protected ByteBuffer buf;
    private int _size;
    private byte[] _random = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();
    static final String[] ONE_BYTE_STRINGS = new String[128];
    private static final Logger log;

    private BSONByteBuffer(ByteBuffer buf) {
        this.buf = buf;
        this._size = this.getInt(0);
        buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static BSONByteBuffer wrap(byte[] bytes, int offset, int length) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes, offset, length));
    }

    public static BSONByteBuffer wrap(byte[] bytes) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes));
    }

    public ByteBuffer slice() {
        return this.buf.slice();
    }

    public ByteBuffer duplicate() {
        return this.buf.duplicate();
    }

    public byte get(int i) {
        return this.buf.get(i);
    }

    public ByteBuffer get(byte[] bytes, int offset, int length) {
        return this.buf.get(bytes, offset, length);
    }

    public ByteBuffer get(byte[] bytes) {
        return this.buf.get(bytes);
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object o) {
        return this.buf.equals(o);
    }

    public int compareTo(ByteBuffer byteBuffer) {
        return this.buf.compareTo(byteBuffer);
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public char getChar(int i) {
        return this.buf.getChar(i);
    }

    public short getShort(int i) {
        return this.buf.getShort(i);
    }

    public int getInt(int i) {
        return this.getInt(i, true);
    }

    public int getInt(int i, boolean littleEndian) {
        return littleEndian ? this.getIntLE(i) : this.getIntBE(i);
    }

    public int getIntLE(int i) {
        int x = 0;
        x |= (0xFF & this.buf.get(i + 0)) << 0;
        x |= (0xFF & this.buf.get(i + 1)) << 8;
        x |= (0xFF & this.buf.get(i + 2)) << 16;
        return x |= (0xFF & this.buf.get(i + 3)) << 24;
    }

    public int getIntBE(int i) {
        int x = 0;
        x |= (0xFF & this.buf.get(i + 0)) << 24;
        x |= (0xFF & this.buf.get(i + 1)) << 16;
        x |= (0xFF & this.buf.get(i + 2)) << 8;
        return x |= (0xFF & this.buf.get(i + 3)) << 0;
    }

    public long getLong(int i) {
        return this.buf.getLong(i);
    }

    public float getFloat(int i) {
        return this.buf.getFloat(i);
    }

    public double getDouble(int i) {
        return this.buf.getDouble(i);
    }

    public String getCString(int i) {
        byte b;
        boolean isAscii = true;
        this._random[0] = this.get(i++);
        if (this._random[0] == 0) {
            return "";
        }
        this._random[1] = this.get(i++);
        if (this._random[1] == 0) {
            String out = ONE_BYTE_STRINGS[this._random[0]];
            if (out != null) {
                return out;
            }
            try {
                return new String(this._random, 0, 1, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BSONException("Cannot decode string as UTF-8");
            }
        }
        this._stringBuffer.reset();
        this._stringBuffer.write(this._random[0]);
        this._stringBuffer.write(this._random[1]);
        boolean bl = isAscii = this._isAscii(this._random[0]) && this._isAscii(this._random[1]);
        while ((b = this.get(i++)) != 0) {
            this._stringBuffer.write(b);
            isAscii = isAscii && this._isAscii(b);
        }
        String out = null;
        if (isAscii) {
            out = this._stringBuffer.asAscii();
        } else {
            try {
                out = this._stringBuffer.asString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BSONException("Cannot decode string as UTF-8");
            }
        }
        this._stringBuffer.reset();
        return out;
    }

    public String getUTF8String(int i) {
        int size = this.getInt(i);
        i += 4;
        if (size <= 0 || size > 0x2000000) {
            throw new BSONException("Bad String Size: " + size);
        }
        if (size == 1) {
            this.get(i);
            return "";
        }
        byte[] b = size < this._random.length ? this._random : new byte[size];
        for (int n = 0; n < size; ++n) {
            b[n] = this.get(i + n);
        }
        try {
            return new String(b, 0, size - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BSONException("Cannot decode string as UTF-8.");
        }
    }

    public Buffer position(int i) {
        return this.buf.position(i);
    }

    public Buffer mark() {
        return this.buf.mark();
    }

    public Buffer reset() {
        return this.buf.reset();
    }

    public Buffer rewind() {
        return this.buf.rewind();
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    protected boolean _isAscii(byte b) {
        return b >= 0 && b <= 127;
    }

    public int size() {
        return this._size;
    }

    static void _fillRange(byte min, byte max) {
        while (min < max) {
            String s = "";
            BSONByteBuffer.ONE_BYTE_STRINGS[min] = s = s + (char)min;
            min = (byte)(min + 1);
        }
    }

    static {
        BSONByteBuffer._fillRange((byte)48, (byte)57);
        BSONByteBuffer._fillRange((byte)97, (byte)122);
        BSONByteBuffer._fillRange((byte)65, (byte)90);
        log = Logger.getLogger("org.bson.io.BSONByteBuffer");
    }
}

