/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import java.util.Map;
import java.util.WeakHashMap;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class EntityTransactionImpl
implements EntityTransaction {
    protected WeakHashMap<QueryImpl, QueryImpl> openQueriesMap;
    protected EntityTransactionWrapper wrapper;
    protected boolean active = false;
    protected boolean rollbackOnly = false;
    protected TransactionFinalizer finalizer;
    public static boolean isFinalizedRequired = false;

    public EntityTransactionImpl(EntityTransactionWrapper wrapper) {
        this.wrapper = wrapper;
        if (isFinalizedRequired) {
            this.finalizer = new TransactionFinalizer();
        }
    }

    public void addOpenQuery(QueryImpl query) {
        if (this.openQueriesMap == null) {
            this.openQueriesMap = new WeakHashMap();
        }
        this.openQueriesMap.put(query, query);
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionIsActive().getMessage());
        }
        this.wrapper.localUOW = this.wrapper.getEntityManager().getActivePersistenceContext(null);
        this.wrapper.localUOW.setShouldTerminateTransaction(false);
        this.active = true;
    }

    protected void closeOpenQueries() {
        if (this.openQueriesMap != null) {
            for (QueryImpl openQuery : this.openQueriesMap.keySet()) {
                openQuery.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.closeOpenQueries();
        try {
            if (this.wrapper.localUOW == null) return;
            this.wrapper.localUOW.setShouldTerminateTransaction(true);
            if (this.rollbackOnly) throw new RollbackException(ExceptionLocalization.buildMessage((String)"rollback_because_of_rollback_only"));
            if (this.wrapper.localUOW.shouldResumeUnitOfWorkOnTransactionCompletion()) {
                this.wrapper.localUOW.commitAndResume();
                return;
            }
            try {
                this.wrapper.localUOW.commit();
                this.wrapper.localUOW.clearForClose(false);
                return;
            }
            catch (RuntimeException exception) {
                try {
                    if (this.wrapper.localUOW != null) {
                        this.wrapper.getEntityManager().removeExtendedPersistenceContext();
                        this.wrapper.localUOW.release();
                        this.wrapper.localUOW.getParent().release();
                    }
                }
                catch (Exception exception2) {}
                if (exception instanceof RollbackException) {
                    throw exception;
                }
                if (!(exception instanceof OptimisticLockException)) throw new RollbackException((Throwable)exception);
                throw new RollbackException((Throwable)new javax.persistence.OptimisticLockException((Throwable)exception));
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void rollback() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.closeOpenQueries();
        try {
            if (this.wrapper.getLocalUnitOfWork() != null) {
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                this.wrapper.localUOW.release();
                this.wrapper.localUOW.getParent().release();
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.getEntityManager().removeExtendedPersistenceContext();
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.rollbackOnly = true;
    }

    protected Map<QueryImpl, QueryImpl> getOpenQueriesMap() {
        if (this.openQueriesMap == null) {
            this.openQueriesMap = new WeakHashMap();
        }
        return this.openQueriesMap;
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.active;
    }

    class TransactionFinalizer {
        TransactionFinalizer() {
        }

        protected void finalize() throws Throwable {
            if (EntityTransactionImpl.this.isActive()) {
                EntityTransactionImpl.this.rollback();
            }
        }
    }
}

