/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredFunctionCall
extends StoredProcedureCall {
    public StoredFunctionCall() {
        this.addUnamedOutputArgument("");
    }

    public StoredFunctionCall(int sqlType, String sqlTypeName, Class javaType) {
        this.addUnamedOutputArgument("", sqlType, sqlTypeName, javaType);
    }

    public StoredFunctionCall(int sqlType, String sqlTypeName, Class javaType, DatabaseField nestedType) {
        this.addUnamedOutputArgument("", sqlType, sqlTypeName, javaType, nestedType);
    }

    public StoredFunctionCall(int sqlType, String sqlTypeName, String javaTypeClassName) {
        this(sqlType, sqlTypeName, (Class)null);
        ObjectRelationalDatabaseField ordf = (ObjectRelationalDatabaseField)this.parameters.get(0);
        ordf.setTypeName(javaTypeClassName);
    }

    public StoredFunctionCall(int sqlType, String sqlTypeName, String javaTypeClassName, DatabaseField nestedType) {
        this(sqlType, sqlTypeName, javaTypeClassName);
        ObjectRelationalDatabaseField ordf = (ObjectRelationalDatabaseField)this.parameters.get(0);
        ordf.setNestedTypeField(nestedType);
    }

    @Override
    public String getCallHeader(DatabasePlatform platform) {
        return platform.getFunctionCallHeader();
    }

    @Override
    public int getFirstParameterIndexForCallString() {
        return 1;
    }

    @Override
    public boolean isStoredFunctionCall() {
        return true;
    }

    @Override
    public void prepareInternal(AbstractSession session) {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.prepareInternal(session);
    }

    public void setResult(String name) {
        DatabaseField returnField = (DatabaseField)this.getParameters().get(0);
        returnField.setName(name);
    }

    public void setResult(String name, Class type) {
        DatabaseField returnField = (DatabaseField)this.getParameters().get(0);
        returnField.setName(name);
        returnField.setType(type);
    }

    public void setResult(String name, int type, String typeName) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField(name);
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        this.getParameters().set(0, field);
    }

    public void setResult(int type, String typeName, Class javaType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField("");
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        this.getParameters().set(0, field);
    }

    public void setResult(int type, String typeName, Class javaType, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field = new ObjectRelationalDatabaseField("");
        field.setSqlType(type);
        field.setSqlTypeName(typeName);
        field.setType(javaType);
        field.setNestedTypeField(nestedType);
        this.getParameters().set(0, field);
    }

    public void setResult(String name, int type) {
        DatabaseField returnField = (DatabaseField)this.getParameters().get(0);
        returnField.setName(name);
        returnField.setSqlType(type);
    }
}

