/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.sql.Date;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.AggregateEventListener;
import org.eclipse.persistence.testing.models.aggregate.Employee;

public class AggregateEventTestCase
extends AutoVerifyTestCase {
    public AggregateEventListener listener;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ((ClassDescriptor)this.getSession().getProject().getDescriptors().get(Employee.class)).getEventManager().removeListener((DescriptorEventListener)this.listener);
    }

    public void setup() {
        this.beginTransaction();
    }

    public void test() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        this.listener = new AggregateEventListener();
        ((ClassDescriptor)session.getProject().getDescriptors().get(AddressDescription.class)).getEventManager().addListener((DescriptorEventListener)this.listener);
        UnitOfWork uow = session.acquireUnitOfWork();
        Employee emp = Employee.example1();
        Employee empClone = (Employee)uow.registerObject((Object)emp);
        uow.commitAndResume();
        Vector events = this.listener.getEvents();
        if (events.size() != 3) {
            throw new TestErrorException("The aggregate events failed to fire");
        }
        if (((DescriptorEvent)events.firstElement()).getEventCode() != 4 || ((DescriptorEvent)events.elementAt(2)).getEventCode() != 1 || ((DescriptorEvent)events.elementAt(1)).getEventCode() != 5) {
            throw new TestErrorException("The appropriate aggregate events failed to fire");
        }
        if (((DescriptorEvent)events.firstElement()).getSource().getClass() != AddressDescription.class) {
            throw new TestErrorException("The wrong object was passed into the event");
        }
        events.removeAllElements();
        empClone.setFirstName("Douglas");
        empClone.getAddressDescription().getPeriodDescription().getPeriod().setEndDate(new Date(System.currentTimeMillis()));
        uow.commit();
        events = this.listener.getEvents();
        if (events.size() != 3) {
            throw new TestErrorException("The appropriate aggregate events failed to fire");
        }
        if (((DescriptorEvent)events.firstElement()).getEventCode() != 6 || ((DescriptorEvent)events.elementAt(2)).getEventCode() != 1 || ((DescriptorEvent)events.elementAt(1)).getEventCode() != 7) {
            throw new TestErrorException("The aggregate events failed to fire");
        }
        events.removeAllElements();
        session.deleteObject((Object)emp);
        events = this.listener.getEvents();
        if (events.size() != 2) {
            throw new TestErrorException("The appropriate aggregate events failed to fire");
        }
        if (((DescriptorEvent)events.firstElement()).getEventCode() != 2 || ((DescriptorEvent)events.elementAt(1)).getEventCode() != 3) {
            throw new TestErrorException("The aggregate events failed to fire");
        }
    }

    public void verify() {
    }
}

