/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.projectxml;

import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeProjectTestSuite {
    public static final String PACKAGE_PREFIX = EmployeeProjectTestSuite.class.getPackage().getName();
    static final String PROJECT_XML = PACKAGE_PREFIX.replace('.', '/') + "/employee-project.xml";
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        DynamicClassLoader dcl = new DynamicClassLoader(EmployeeProjectTestSuite.class.getClassLoader());
        Project project = null;
        try {
            project = DynamicTypeBuilder.loadDynamicProject((String)PROJECT_XML, (DatabaseLogin)DynamicTestingHelper.createLogin(), (DynamicClassLoader)dcl);
        }
        catch (IOException e) {
            Assert.fail((String)"cannot find employee-project.xml");
        }
        session = project.createDatabaseSession();
        if (8 == DynamicTestingHelper.logLevel) {
            session.dontLogMessages();
        } else {
            session.setLogLevel(DynamicTestingHelper.logLevel);
        }
        dynamicHelper = new DynamicHelper(session);
        session.login();
        new SchemaManager(session).replaceDefaultTables();
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE DX_SALARY");
        session.executeNonSelectingSQL("DROP TABLE DX_EMPLOYEE");
        session.executeNonSelectingSQL("DROP TABLE DX_ADDRESS");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDatabase() {
        session.executeNonSelectingSQL("DELETE FROM DX_SALARY");
        session.executeNonSelectingSQL("DELETE FROM DX_EMPLOYEE");
        session.executeNonSelectingSQL("DELETE FROM DX_ADDRESS");
    }

    @Test
    public void createNewInstance() throws Exception {
        DynamicType employeeType = dynamicHelper.getType("Employee");
        DynamicType periodType = dynamicHelper.getType("EmploymentPeriod");
        DynamicEntity entity = employeeType.newDynamicEntity();
        entity.set("firstName", (Object)"First");
        entity.set("lastName", (Object)"Last");
        entity.set("salary", (Object)12345);
        DynamicEntity period = periodType.newDynamicEntity();
        period.set("startDate", (Object)Calendar.getInstance());
        entity.set("period", (Object)period);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)entity);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("Employee", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        session.release();
    }

    @Test
    public void readAll() throws Exception {
        this.createNewInstance();
        DynamicType type = dynamicHelper.getType("Employee");
        Vector allObjects = session.readAllObjects(type.getJavaClass());
        Assert.assertEquals((long)1L, (long)allObjects.size());
    }
}

