/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.history;

import java.util.ArrayList;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.mapping.Baby;
import org.eclipse.persistence.testing.models.mapping.BabyMonitor;
import org.eclipse.persistence.testing.models.mapping.BiDirectionInserOrderTestProject;
import org.eclipse.persistence.testing.models.mapping.BiDirectionInsertOrderTableMaker;
import org.eclipse.persistence.tools.history.HistoryFacade;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;

public class InsertWithHistoryPolicyTest
extends TestCase {
    DatabaseSession dbSession;
    protected DatabaseException caughtException = null;
    protected static boolean isHistoryFirstCreation = true;

    public InsertWithHistoryPolicyTest() {
        this.setDescription("Tests insert for bi-directional 1 - 1 mapping with history policy.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup() {
        if (this.getSession().getPlatform().isMySQL() || this.getSession().getPlatform().isSybase()) {
            this.throwWarning("This test will not work with MySQL or Sybase because it doesn't support millisecond granularity.");
        }
        BiDirectionInserOrderTestProject project = new BiDirectionInserOrderTestProject();
        DatabaseLogin databaseLogin = (DatabaseLogin)this.getSession().getLogin().clone();
        project.setLogin(databaseLogin);
        this.dbSession = project.createDatabaseSession();
        this.dbSession.setSessionLog(this.getSession().getSessionLog());
        HistoryFacade.generateHistoryPolicies((Session)this.dbSession);
        BiDirectionInsertOrderTableMaker creator = new BiDirectionInsertOrderTableMaker();
        this.dbSession.login();
        creator.replaceTables(this.dbSession);
        ArrayList origTableDefs = new ArrayList(creator.getTableDefinitions());
        HistoryFacade.generateHistoricalTableDefinitions((TableCreator)creator, (Session)this.dbSession);
        creator.getTableDefinitions().removeAll(origTableDefs);
        boolean org_FAST_TABLE_CREATOR = false;
        if (isHistoryFirstCreation && creator.isFastTableCreator()) {
            creator.resetFastTableCreator();
            org_FAST_TABLE_CREATOR = SchemaManager.FAST_TABLE_CREATOR;
            SchemaManager.FAST_TABLE_CREATOR = false;
        }
        try {
            creator.replaceTables(this.dbSession);
        }
        finally {
            if (org_FAST_TABLE_CREATOR) {
                SchemaManager.FAST_TABLE_CREATOR = true;
            }
        }
        isHistoryFirstCreation = false;
    }

    protected void test() {
        UnitOfWork uow = this.dbSession.acquireUnitOfWork();
        Baby baby = new Baby();
        BabyMonitor monitor = new BabyMonitor();
        baby.setBabyMonitor(monitor);
        monitor.setBaby(baby);
        uow.registerObject((Object)baby);
        try {
            uow.commit();
        }
        catch (DatabaseException dbe) {
            this.caughtException = dbe;
        }
    }

    protected void verify() {
        if (this.caughtException != null) {
            if (this.caughtException.getDatabaseErrorCode() == 1400) {
                this.throwError("Invalid attempt to insert null value into history table for non-null defined field.", this.caughtException);
            } else {
                this.throwError(this.caughtException.getMessage(), this.caughtException);
            }
        }
    }
}

