/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.mapping.Phone;
import org.eclipse.persistence.testing.tests.proxyindirection.ProxyIndirectionSystem;
import org.eclipse.persistence.testing.tests.queries.oracle.BasicReadTest;
import org.eclipse.persistence.testing.tests.queries.oracle.ChangedHintStringTest;
import org.eclipse.persistence.testing.tests.queries.oracle.DeleteTestCase;
import org.eclipse.persistence.testing.tests.queries.oracle.HierarchicalOneToOneTest;
import org.eclipse.persistence.testing.tests.queries.oracle.HierarchicalQueryWithInheritenceTest;
import org.eclipse.persistence.testing.tests.queries.oracle.HierarchicalQueryWithWhere;
import org.eclipse.persistence.testing.tests.queries.oracle.IndirectionTest;
import org.eclipse.persistence.testing.tests.queries.oracle.JoinInWhereClauseTest;
import org.eclipse.persistence.testing.tests.queries.oracle.OrderSiblingsTest;
import org.eclipse.persistence.testing.tests.queries.oracle.ReadWholeHierarchyTest;
import org.eclipse.persistence.testing.tests.queries.oracle.UpdateTestCase;

public class OracleSpecificTestModel
extends TestModel {
    public OracleSpecificTestModel() {
        this.setDescription("This model tests the use of Oracle Hints and Hierarchical Queries on Oracle databases");
    }

    public void addRequiredSystems() {
        if (this.getSession().getPlatform().isOracle()) {
            this.addRequiredSystem(new MappingSystem());
            this.addRequiredSystem(new ProxyIndirectionSystem());
            this.addRequiredSystem(new InheritanceSystem());
        }
    }

    public void addTests() {
        if (this.getSession().getPlatform().isOracle()) {
            this.addTest((Test)OracleSpecificTestModel.getOracleHintsTestSuite());
            this.addTest((Test)OracleSpecificTestModel.getHierarchicalQueriesTestSuite());
        }
    }

    public static TestSuite getOracleHintsTestSuite() {
        TestSuite testSuite = new TestSuite();
        testSuite.setName("OracleHintsTestSuite");
        testSuite.setDescription("Tests the Oracle Hints feature");
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        BasicReadTest tc1 = new BasicReadTest((DatabaseQuery)raq);
        tc1.setName("ReadAllTest");
        tc1.setDescription("Tests hints on a ReadAllQuery");
        testSuite.addTest((Test)tc1);
        ReadObjectQuery roq = new ReadObjectQuery(Employee.class);
        Employee emp = new Employee();
        emp.firstName = "Bill";
        roq.setExampleObject((Object)emp);
        BasicReadTest tc2 = new BasicReadTest((DatabaseQuery)roq);
        tc2.setName("QBE Test");
        tc2.setDescription("Tests hints using a Query By Example");
        testSuite.addTest((Test)tc2);
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder raqb = new ExpressionBuilder(Employee.class);
        ExpressionBuilder rqb = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(Phone.class, rqb);
        BasicReadTest test = new BasicReadTest((DatabaseQuery)query);
        Expression exp = rqb.get("areaCode").equal(raqb.get("lastName"));
        rq.setSelectionCriteria(exp);
        rq.addAttribute("areaCode");
        rq.setHintString(BasicReadTest.INNER_HINT);
        Expression expression = raqb.get("lastName").in(rq);
        query.setSelectionCriteria(expression);
        test.setName("HintsInSubselectsTest");
        test.setDescription("Test hints with subselects");
        testSuite.addTest((Test)test);
        ExpressionBuilder eb = new ExpressionBuilder();
        ReadAllQuery query2 = new ReadAllQuery(Employee.class);
        Expression expr1 = eb.get("firstName").like("%av%");
        Expression expr2 = eb.get("cubicle").get("location").equal((Object)"2nd floor, Section P, Close to the Middle");
        Expression expr3 = expr1.and(expr2);
        query2.setSelectionCriteria(expr3);
        BasicReadTest test2 = new BasicReadTest((DatabaseQuery)query2);
        test2.setName("Complex Query Test");
        test2.setDescription("Test hints in a complex query");
        testSuite.addTest((Test)test2);
        testSuite.addTest((Test)new UpdateTestCase());
        testSuite.addTest((Test)new DeleteTestCase());
        testSuite.addTest((Test)new ChangedHintStringTest());
        return testSuite;
    }

    public static TestSuite getHierarchicalQueriesTestSuite() {
        TestSuite testSuite = new TestSuite();
        testSuite.setName("HierarchicalQueriesTestSuite");
        testSuite.addTest((Test)new ReadWholeHierarchyTest());
        testSuite.addTest((Test)new HierarchicalQueryWithWhere());
        testSuite.addTest((Test)new OrderSiblingsTest());
        testSuite.addTest((Test)new JoinInWhereClauseTest());
        testSuite.addTest((Test)new HierarchicalOneToOneTest());
        testSuite.addTest((Test)new IndirectionTest());
        testSuite.addTest((Test)new HierarchicalQueryWithInheritenceTest());
        return testSuite;
    }
}

