/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessioncache;

import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteNewPessimisticLockedObjectTest
extends TestCase {
    private CMPPolicy oldCMPPolicy;
    private int oldLevel;

    public WriteNewPessimisticLockedObjectTest() {
        this.setDescription("The test ensures that new pessimistically locked objects are not  put in the session cache");
    }

    protected void setup() {
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode((short)2);
        CMPPolicy cmpPolicy = new CMPPolicy();
        cmpPolicy.setPessimisticLockingPolicy(policy);
        ClassDescriptor empDescriptor = this.getSession().getDescriptor(Employee.class);
        this.oldCMPPolicy = empDescriptor.getCMPPolicy();
        empDescriptor.setCMPPolicy(cmpPolicy);
        empDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        this.oldLevel = empDescriptor.getUnitOfWorkCacheIsolationLevel();
        empDescriptor.setUnitOfWorkCacheIsolationLevel(4);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee empInsert = new Employee();
        empInsert.setFirstName("TestPerson");
        empInsert.setFemale();
        empInsert.setLastName("Smith");
        empInsert.setSalary(55555);
        uow.registerObject((Object)empInsert);
        uow.commit();
    }

    protected void verify() {
        IdentityMap im = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (im.getSize() > 0) {
            throw new TestErrorException("Employee should not have been put into session cache.");
        }
    }

    public void reset() throws Exception {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).setCMPPolicy(this.oldCMPPolicy);
        this.getSession().getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(this.oldLevel);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

