/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.validation.ConstructorProject;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ConstructorTest
extends ExceptionTest {
    protected EclipseLinkException secondExpectedException;
    protected EclipseLinkException thirdExpectedException;

    public void setup() {
        this.expectedException = DescriptorException.illegalAccessWhileConstructorInstantiation(null, null);
        this.secondExpectedException = DescriptorException.noSuchMethodWhileConstructorInstantiation(null, null);
        this.thirdExpectedException = DescriptorException.noSuchMethodWhileInitializingInstantiationPolicy(null, null, null);
    }

    public void test() {
        DatabaseSession testSession = null;
        try {
            ConstructorProject project = new ConstructorProject();
            project.setLogin(this.getSession().getLogin());
            testSession = project.createDatabaseSession();
            testSession.dontLogMessages();
            testSession.login();
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
        catch (Exception e) {
            throw new TestWarningException("A non-TopLink exception is caught.");
        }
        finally {
            if (testSession != null && testSession.isConnected()) {
                testSession.logout();
            }
        }
    }

    @Override
    protected void verify() {
        if (this.caughtException == null) {
            this.throwError("The proper exception was not thrown:" + Helper.cr() + "caught exception was null! " + Helper.cr() + Helper.cr() + "[EXPECTING] " + (Object)((Object)this.expectedException) + " or " + (Object)((Object)this.secondExpectedException));
        }
        if (this.caughtException instanceof IntegrityException) {
            boolean illegalAccessConstructorInit = false;
            boolean noSuchMethodConstructorInit = false;
            boolean noSuchMethodInstantiationInit = false;
            IntegrityChecker ic = new IntegrityChecker();
            ic = ((IntegrityException)((Object)this.caughtException)).getIntegrityChecker();
            Vector exceptionList = ic.getCaughtExceptions();
            for (int i = 0; i < exceptionList.size(); ++i) {
                if (!(exceptionList.elementAt(i) instanceof DescriptorException)) continue;
                if (((DescriptorException)((Object)exceptionList.elementAt(i))).getErrorCode() == 15) {
                    illegalAccessConstructorInit = true;
                }
                if (((DescriptorException)((Object)exceptionList.elementAt(i))).getErrorCode() == 57) {
                    noSuchMethodConstructorInit = true;
                }
                if (((DescriptorException)((Object)exceptionList.elementAt(i))).getErrorCode() != 63) continue;
                noSuchMethodInstantiationInit = true;
            }
            String cr = Helper.cr();
            if (!(illegalAccessConstructorInit || noSuchMethodConstructorInit || noSuchMethodInstantiationInit)) {
                throw new TestErrorException("The proper exception was not thrown:" + cr + "[CAUGHT] " + (Object)((Object)this.caughtException) + cr + cr + "[EXPECTING] " + this.expectedException.getMessage() + cr + " or " + this.secondExpectedException.getMessage() + cr + " or " + this.thirdExpectedException.getMessage());
            }
        }
    }
}

