/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.Bag;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class BagTests
extends TestCase {
    public BagTests(String name) {
        super(name);
    }

    public void testEmptyBag_iterator() throws Exception {
        BagTests.assertFalse((boolean)Bag.Empty.instance().iterator().hasNext());
    }

    public void testEmptyBag_size() throws Exception {
        BagTests.assertEquals((int)0, (int)Bag.Empty.instance().size());
    }

    public void testEmptyBag_uniqueIterator() throws Exception {
        BagTests.assertFalse((boolean)Bag.Empty.instance().uniqueIterator().hasNext());
    }

    public void testEmptyBag_uniqueCount() throws Exception {
        BagTests.assertEquals((int)0, (int)Bag.Empty.instance().uniqueCount());
    }

    public void testEmptyBag_count() throws Exception {
        BagTests.assertEquals((int)0, (int)Bag.Empty.instance().count((Object)"foo"));
    }

    public void testEmptyBag_entries() throws Exception {
        BagTests.assertFalse((boolean)Bag.Empty.instance().entries().hasNext());
    }

    public void testEmptyBag_remove() throws Exception {
        BagTests.assertFalse((boolean)Bag.Empty.instance().remove((Object)"foo", 3));
    }

    public void testEmptyBag_add() throws Exception {
        boolean exCaught = false;
        try {
            Bag.Empty.instance().add((Object)"foo", 3);
            BagTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyBag_equals() throws Exception {
        BagTests.assertTrue((boolean)Bag.Empty.instance().equals((Object)Bag.Empty.instance()));
        BagTests.assertFalse((boolean)Bag.Empty.instance().equals((Object)"foo"));
        HashBag bag = new HashBag();
        BagTests.assertTrue((boolean)Bag.Empty.instance().equals((Object)bag));
        bag.add((Object)"foo");
        BagTests.assertFalse((boolean)Bag.Empty.instance().equals((Object)bag));
    }

    public void testEmptyBag_hashCode() throws Exception {
        BagTests.assertEquals((int)0, (int)Bag.Empty.instance().hashCode());
    }

    public void testEmptyBag_serialization() throws Exception {
        Bag xxx = TestTools.serialize(Bag.Empty.instance());
        BagTests.assertSame((Object)Bag.Empty.instance(), (Object)xxx);
    }
}

