/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementListIterator;
import org.eclipse.persistence.tools.utility.tests.iterator.SingleElementIteratorTests;

public class SingleElementListIteratorTests
extends SingleElementIteratorTests {
    public SingleElementListIteratorTests(String name) {
        super(name);
    }

    public void testNextIndex() {
        ListIterator<String> stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.nextIndex());
            stream.next();
        }
        SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)1, (int)stream.nextIndex());
    }

    public void testHasPrevious() {
        int i = 0;
        ListIterator<String> stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        SingleElementListIteratorTests.assertEquals((int)1, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        SingleElementListIteratorTests.assertEquals((int)2, (int)i);
    }

    public void testPrevious() {
        ListIterator<String> stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus element", (String)this.singleElement(), (String)stream.next());
        }
        while (stream.hasPrevious()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus element", (String)this.singleElement(), (String)stream.previous());
        }
    }

    public void testPreviousIndex() {
        ListIterator<String> stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.nextIndex());
            stream.next();
        }
        while (stream.hasPrevious()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.previousIndex());
            stream.previous();
        }
        SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)-1, (int)stream.previousIndex());
    }

    public void testAdd() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildSingleElementListIterator();
        try {
            stream.add("foo");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        SingleElementListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(this.singleElement())) continue;
            try {
                stream.set("foo");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        SingleElementListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    @Override
    protected Iterator<String> buildSingleElementIterator() {
        return new SingleElementListIterator((Object)this.singleElement());
    }

    protected ListIterator<String> buildSingleElementListIterator() {
        return (ListIterator)this.buildSingleElementIterator();
    }
}

