/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.ChangeSupport;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.SingleAspectChangeSupport;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

public class SingleAspectChangeSupportTests
extends TestCase {
    public SingleAspectChangeSupportTests(String name) {
        super(name);
    }

    public void testAddPropertyChangeListenerInvalidClass() {
        StateTestModel model = new StateTestModel();
        boolean exCaught = false;
        PropertyChangeAdapter listener = new PropertyChangeAdapter();
        try {
            model.addPropertyChangeListener("foo", (PropertyChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddPropertyChangeListenerInvalidAspect() {
        PropertyTestModel model = new PropertyTestModel();
        boolean exCaught = false;
        PropertyChangeAdapter listener = new PropertyChangeAdapter();
        try {
            model.addPropertyChangeListener("bar", (PropertyChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddCollectionChangeListenerInvalidClass() {
        StateTestModel model = new StateTestModel();
        boolean exCaught = false;
        CollectionChangeAdapter listener = new CollectionChangeAdapter();
        try {
            model.addCollectionChangeListener("foo", (CollectionChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddCollectionChangeListenerInvalidAspect() {
        CollectionTestModel model = new CollectionTestModel();
        boolean exCaught = false;
        CollectionChangeAdapter listener = new CollectionChangeAdapter();
        try {
            model.addCollectionChangeListener("bar", (CollectionChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddListChangeListenerInvalidClass() {
        StateTestModel model = new StateTestModel();
        boolean exCaught = false;
        ListChangeAdapter listener = new ListChangeAdapter();
        try {
            model.addListChangeListener("foo", (ListChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddListChangeListenerInvalidAspect() {
        ListTestModel model = new ListTestModel();
        boolean exCaught = false;
        ListChangeAdapter listener = new ListChangeAdapter();
        try {
            model.addListChangeListener("bar", (ListChangeListener)listener);
            SingleAspectChangeSupportTests.fail((String)("bogus listener: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        SingleAspectChangeSupportTests.assertTrue((boolean)exCaught);
    }

    static class CollectionTestModel
    extends AbstractModel {
        CollectionTestModel() {
        }

        protected ChangeSupport buildChangeSupport() {
            return new SingleAspectChangeSupport((Model)this, CollectionChangeListener.class, "foo");
        }
    }

    static class ListTestModel
    extends AbstractModel {
        ListTestModel() {
        }

        protected ChangeSupport buildChangeSupport() {
            return new SingleAspectChangeSupport((Model)this, ListChangeListener.class, "foo");
        }
    }

    static class PropertyTestModel
    extends AbstractModel {
        PropertyTestModel() {
        }

        protected ChangeSupport buildChangeSupport() {
            return new SingleAspectChangeSupport((Model)this, PropertyChangeListener.class, "foo");
        }
    }

    static class StateTestModel
    extends AbstractModel {
        StateTestModel() {
        }

        protected ChangeSupport buildChangeSupport() {
            return new SingleAspectChangeSupport((Model)this, StateChangeListener.class, null);
        }
    }
}

