/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.w3c.dom.Node;

public final class JDBCTypeToDatabaseTypeMapping
extends AbstractNode {
    private JDBCType jdbcType;
    private DatabaseType databaseType;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform platform, Node node) throws CorruptXMLException {
        super((org.eclipse.persistence.tools.utility.node.Node)platform);
        this.read(node);
    }

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform platform, JDBCType jdbcType) {
        super((org.eclipse.persistence.tools.utility.node.Node)platform);
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        this.jdbcType = jdbcType;
    }

    private DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.getParent();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        DatabaseType old = this.databaseType;
        this.databaseType = databaseType;
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, (Object)old, (Object)databaseType);
    }

    boolean maps(JDBCType type) {
        return this.jdbcType == type;
    }

    boolean maps(int jdbcTypeCode) {
        return this.jdbcType.getCode() == jdbcTypeCode;
    }

    private JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.getPlatform().jdbcTypeNamed(jdbcTypeName);
    }

    private DatabaseType databaseTypeNamed(String databaseTypeName) {
        return this.getPlatform().databaseTypeNamed(databaseTypeName);
    }

    void cloneFrom(JDBCTypeToDatabaseTypeMapping originalMapping) {
        DatabaseType originalDatabaseType = originalMapping.getDatabaseType();
        if (originalDatabaseType != null) {
            this.databaseType = this.databaseTypeNamed(originalDatabaseType.getName());
        }
    }

    private void read(Node node) throws CorruptXMLException {
        try {
            this.jdbcType = this.jdbcTypeNamed(XMLTools.getChildTextContent((Node)node, (String)"jdbc-type", null));
        }
        catch (IllegalArgumentException ex) {
            throw new CorruptXMLException("platform: " + this.getPlatform().getName(), ex);
        }
        String databaseTypeName = XMLTools.getChildTextContent((Node)node, (String)"database-type", null);
        if (databaseTypeName != null) {
            try {
                this.databaseType = this.databaseTypeNamed(databaseTypeName);
            }
            catch (IllegalArgumentException ex) {
                throw new CorruptXMLException(ex);
            }
        }
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode((Node)node, (String)"jdbc-type", (String)this.jdbcType.getName());
        if (this.databaseType != null) {
            XMLTools.addSimpleTextNode((Node)node, (String)"database-type", (String)this.databaseType.getName());
        }
    }

    private void displayStringOn(StringBuffer sb) {
        sb.append(this.jdbcType.getName());
        sb.append(" => ");
        sb.append(this.databaseType == null ? "null" : this.databaseType.getName());
    }

    public String displayString() {
        StringBuffer sb = new StringBuffer();
        this.displayStringOn(sb);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.displayStringOn(sb);
    }
}

