/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.value.AbstractCollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;

public abstract class CollectionValueModelWrapper<E>
extends AbstractCollectionValueModel {
    protected final CollectionValueModel<? extends E> collectionModel;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel<? extends E> collectionModel) {
        if (collectionModel == null) {
            throw new NullPointerException();
        }
        this.collectionModel = collectionModel;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            @Override
            public void itemsAdded(CollectionAddEvent event) {
                CollectionValueModelWrapper.this.itemsAdded(event);
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent event) {
                CollectionValueModelWrapper.this.itemsRemoved(event);
            }

            @Override
            public void collectionCleared(CollectionClearEvent event) {
                CollectionValueModelWrapper.this.collectionCleared(event);
            }

            @Override
            public void collectionChanged(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    protected void engageModel() {
        this.collectionModel.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    @Override
    protected void disengageModel() {
        this.collectionModel.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected Iterable<E> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected abstract void itemsAdded(CollectionAddEvent var1);

    protected abstract void itemsRemoved(CollectionRemoveEvent var1);

    protected abstract void collectionCleared(CollectionClearEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

