/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyCompositeListIterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;
import org.eclipse.persistence.tools.utility.model.event.ListAddEvent;
import org.eclipse.persistence.tools.utility.model.event.ListChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.ListClearEvent;
import org.eclipse.persistence.tools.utility.model.event.ListMoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModelWrapper;

public class ExtendedListValueModelWrapper<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected List<E> prefix;
    protected List<E> suffix;

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(List<? extends E> prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = new ArrayList<E>(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(E prefix, ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(prefix);
        this.suffix = Collections.emptyList();
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, List<? extends E> suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = new ArrayList<E>(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder, E suffix) {
        super(listHolder);
        this.prefix = Collections.emptyList();
        this.suffix = Collections.singletonList(suffix);
    }

    public ExtendedListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        super(listHolder);
        this.prefix = Collections.singletonList(null);
        this.suffix = Collections.emptyList();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.listIterator_());
    }

    protected ListIterator<E> listIterator_() {
        return new ReadOnlyCompositeListIterator(this.prefix.listIterator(), this.listModel.listIterator(), this.suffix.listIterator());
    }

    @Override
    public E get(int index) {
        int prefixSize = this.prefix.size();
        if (index < prefixSize) {
            return this.prefix.get(index);
        }
        if (index >= prefixSize + this.listModel.size()) {
            return this.suffix.get(index - (prefixSize + this.listModel.size()));
        }
        return this.listModel.get(index - prefixSize);
    }

    @Override
    public int size() {
        return this.prefix.size() + this.listModel.size() + this.suffix.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>(this.size());
        list.addAll(this.prefix);
        CollectionTools.addAll(list, this.listModel.iterator());
        list.addAll(this.suffix);
        return list.toArray();
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.fireItemsAdded(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.fireItemsReplaced(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.fireItemsMoved(event.clone(this, "list values", this.prefix.size()));
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.fireListChanged("list values", this.buildList());
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.fireListChanged("list values", this.buildList());
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }

    public void setPrefix(List<E> prefix) {
        this.prefix = prefix;
        this.fireListChanged("list values", this.buildList());
    }

    public void setSuffix(List<E> suffix) {
        this.suffix = suffix;
        this.fireListChanged("list values", this.buildList());
    }

    private List<E> buildList() {
        return ListTools.list(this.listIterator_());
    }
}

