/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.persistence.tools.utility.Range;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.value.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;

public class SortedListValueModelAdapter<E>
extends CollectionListValueModelAdapter<E> {
    protected Comparator<E> comparator;

    public SortedListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder, Comparator<E> comparator) {
        super(collectionHolder);
        this.comparator = comparator;
    }

    public SortedListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        this(collectionHolder, null);
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
        this.sortList();
    }

    @Override
    protected void buildList(int size) {
        super.buildList(size);
        Collections.sort(this.list, this.comparator);
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        ArrayList newList = (ArrayList)this.list.clone();
        newList.ensureCapacity(newList.size() + event.getItemsSize());
        CollectionTools.addAll(newList, this.getItems(event));
        Collections.sort(newList, this.comparator);
        this.synchronizeList(newList, this.list, "list values");
    }

    @Override
    protected Iterable<? extends E> buildSyncList() {
        return CollectionTools.sortedSet(this.collectionHolder, this.comparator, this.collectionHolder.size());
    }

    protected void sortList() {
        ArrayList unsortedList = (ArrayList)this.list.clone();
        Collections.sort(this.list, this.comparator);
        Range diffRange = ListTools.identityDifferenceRange(unsortedList, this.list);
        if (diffRange.size > 0) {
            List unsortedItems = unsortedList.subList(diffRange.start, diffRange.end + 1);
            List sortedItems = this.list.subList(diffRange.start, diffRange.end + 1);
            this.fireItemsReplaced("list values", diffRange.start, sortedItems, unsortedItems);
        }
    }
}

