/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.AccessType;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.Converter;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.PersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.dom.SQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class ORMConfiguration
extends AbstractExternalForm
implements ExternalORMConfiguration {
    private Document document;
    static final String ACCESS = "access";
    static final String CATALOG = "catalog";
    static final String DESCRIPTION = "description";
    static final String ENTITY_MAPPINGS = "entity-mappings";
    static final String PACKAGE = "package";
    static final String SCHEMA = "schema";

    ORMConfiguration(Document document) {
        super(null);
        this.document = document;
    }

    @Override
    public ExternalConverter addConverter(int index) {
        Converter converter = this.buildConverter(index);
        converter.addSelf();
        return converter;
    }

    @Override
    public ExternalTenantDiscriminatorColumn addDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
        column.addSelf();
        return column;
    }

    @Override
    public void addEmbeddableEntity(int index, String className) {
        EmbeddableEntity entity = this.buildEmbeddableEntity(index);
        entity.addSelf();
        entity.setClassName(className);
    }

    @Override
    public ExternalEmbeddableEntity addEmbeddableEntity(String className) {
        EmbeddableEntity entity = this.buildEmbeddableEntity(this.embeddableEntitiesSize());
        entity.addSelf();
        entity.setClassName(className);
        return entity;
    }

    @Override
    public void addEntity(int index, String className) {
        Entity entity = this.buildEntity(index);
        entity.addSelf();
        entity.setClassName(className);
    }

    @Override
    public ExternalEntity addEntity(String entityClassName) {
        Entity entity = this.buildEntity(this.entitiesSize());
        entity.addSelf();
        entity.setClassName(entityClassName);
        return entity;
    }

    @Override
    public void addMappedSuperClass(int index, String className) {
        MappedSuperClassEntity entity = this.buildMappedSuperclass(index);
        entity.addSelf();
        entity.setClassName(className);
    }

    @Override
    public void addNamedNativeQuery(int index, String name) {
        NamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(index);
        namedNativeQuery.addSelf();
        namedNativeQuery.setName(name);
    }

    @Override
    public ExternalNamedQuery addNamedQuery(int index, String name) {
        NamedQuery namedQuery = this.buildNamedQuery(index);
        namedQuery.addSelf();
        namedQuery.setName(name);
        return namedQuery;
    }

    @Override
    public ExternalNamedQuery addNamedQuery(String name) {
        NamedQuery namedQuery = this.buildNamedQuery(this.namedQueriesSize());
        namedQuery.addSelf();
        namedQuery.setName(name);
        return namedQuery;
    }

    @Override
    public ExternalObjectTypeConverter addObjectTypeConverter(int index) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.addSelf();
        return converter;
    }

    @Override
    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, Collections.<String>emptyList());
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        Document document = this.getDocument();
        Element element = document.createElementNS("http://www.eclipse.org/eclipselink/xsds/persistence/orm", elementName);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.eclipse.org/eclipselink/xsds/persistence/orm");
        this.addXmlns(element, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", this.buildSchemaLocation(ORMDocumentType.ECLIPELINK_2_5));
        element.setAttribute("version", this.getBuildVersion());
        document.appendChild(element);
        return element;
    }

    @Override
    public void addSequenceGenerator(int index, String name) {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator(index);
        sequenceGenerator.addSelf();
        sequenceGenerator.setName(name);
    }

    @Override
    public void addSqlResultSetMapping(int index, String name) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.addSelf();
        sqlResultSetMapping.setName(name);
    }

    @Override
    public void addStoredProcedureQuery(int index, String name, String procedureName) {
        NamedStoredProcedureQuery storedProcedureQuery = this.buildStoredProcedureQuery(index);
        storedProcedureQuery.addSelf();
        storedProcedureQuery.setName(name);
        storedProcedureQuery.setProcedureName(procedureName);
    }

    @Override
    public ExternalStructConverter addStructConverter(int index) {
        StructConverter converter = this.buildStructConverter(index);
        converter.addSelf();
        return converter;
    }

    @Override
    public void addTableGenerator(int index, String name) {
        TableGenerator sequenceGenerator = this.buildTableGenerator(index);
        sequenceGenerator.addSelf();
        sequenceGenerator.setName(name);
    }

    @Override
    public ExternalTypeConverter addTypeConverter(int index) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.addSelf();
        return converter;
    }

    private Converter buildConverter(int index) {
        return new Converter(this, index);
    }

    private TenantDiscriminatorColumn buildDiscriminatorColumn(int index) {
        return new TenantDiscriminatorColumn(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add("persistence-unit-metadata");
        names.add(PACKAGE);
        names.add(SCHEMA);
        names.add(CATALOG);
        names.add(ACCESS);
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("sequence-generator");
        names.add("table-generator");
        names.add("named-query");
        names.add("named-native-query");
        names.add("named-stored-procedure-query");
        names.add("sql-result-set-mapping");
        names.add("mapped-superclass");
        names.add("entity");
        names.add("embeddable");
        return names;
    }

    private EmbeddableEntity buildEmbeddableEntity(int index) {
        return new EmbeddableEntity(this, index);
    }

    private Entity buildEntity(int index) {
        return new Entity(this, index);
    }

    private MappedSuperClassEntity buildMappedSuperclass(int index) {
        return new MappedSuperClassEntity(this, index);
    }

    private NamedNativeQuery buildNamedNativeQuery(int index) {
        return new NamedNativeQuery(this, index);
    }

    private NamedQuery buildNamedQuery(int index) {
        return new NamedQuery(this, index);
    }

    private ObjectTypeConverter buildObjectTypeConverter(int index) {
        return new ObjectTypeConverter(this, index);
    }

    private PersistenceUnit buildPersistenceUnit() {
        return new PersistenceUnit(this);
    }

    @Override
    public ExternalPersistenceUnit buildPersistenceUnitMetaData() {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit();
        persistenceUnit.addSelf();
        return persistenceUnit;
    }

    private String buildSchemaLocation(ORMDocumentType version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version.getXmlNamespace());
        sb.append(" ");
        sb.append(version.getSchemaURI());
        return sb.toString();
    }

    private SequenceGenerator buildSequenceGenerator(int index) {
        return new SequenceGenerator(this, index);
    }

    private SQLResultSetMapping buildSqlResultSetMapping(int index) {
        return new SQLResultSetMapping(this, index);
    }

    private NamedStoredProcedureQuery buildStoredProcedureQuery(int index) {
        return new NamedStoredProcedureQuery(this, index);
    }

    private StructConverter buildStructConverter(int index) {
        return new StructConverter(this, index);
    }

    private TableGenerator buildTableGenerator(int index) {
        return new TableGenerator(this, index);
    }

    private TypeConverter buildTypeConverter(int index) {
        return new TypeConverter(this, index);
    }

    @Override
    public ListIterable<ExternalConverter> converters() {
        int count = this.convertersSize();
        ArrayList<Converter> converters = new ArrayList<Converter>(count);
        int index = count;
        while (--index >= 0) {
            Converter converter = this.buildConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public int convertersSize() {
        return this.getChildrenSize("converter");
    }

    @Override
    public ListIterable<ExternalTenantDiscriminatorColumn> discriminatorColumns() {
        int count = this.discriminatorColumnSize();
        ArrayList<TenantDiscriminatorColumn> columns = new ArrayList<TenantDiscriminatorColumn>(count);
        int index = count;
        while (--index >= 0) {
            TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
            columns.add(0, column);
        }
        return new ListListIterable(columns);
    }

    @Override
    public int discriminatorColumnSize() {
        return this.getChildrenSize("tenant-discriminator-column");
    }

    @Override
    public ListIterable<ExternalEmbeddableEntity> embeddableEntities() {
        int count = this.embeddableEntitiesSize();
        ArrayList<EmbeddableEntity> entities = new ArrayList<EmbeddableEntity>(count);
        int index = count;
        while (--index >= 0) {
            EmbeddableEntity entity = this.buildEmbeddableEntity(index);
            entities.add(0, entity);
        }
        return new ListListIterable(entities);
    }

    @Override
    public int embeddableEntitiesSize() {
        return this.getChildrenSize("embeddable");
    }

    @Override
    public ListIterable<ExternalEntity> entities() {
        int count = this.entitiesSize();
        ArrayList<Entity> entities = new ArrayList<Entity>(count);
        int index = count;
        while (--index >= 0) {
            Entity entity = this.buildEntity(index);
            entities.add(0, entity);
        }
        return new ListListIterable(entities);
    }

    @Override
    public int entitiesSize() {
        return this.getChildrenSize("entity");
    }

    @Override
    public AccessType getAccessType() {
        return this.getChildEnumNode(ACCESS, AccessType.class);
    }

    @Override
    public String getBuildVersion() {
        return "2.0";
    }

    @Override
    public String getCatalogName() {
        return this.getChildTextNode(CATALOG);
    }

    @Override
    public ExternalConverter getConverter(int index) {
        Element element = this.getChild("converter", index);
        if (element == null) {
            return null;
        }
        return this.buildConverter(index);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index) {
        Element element = this.getChild("tenant-discriminator-column", index);
        if (element == null) {
            return null;
        }
        return this.buildDiscriminatorColumn(index);
    }

    @Override
    protected Document getDocument() {
        return this.document;
    }

    @Override
    public ORMDocumentType getDocumentType() {
        return ORMDocumentType.value(this.getNamespace(), this.getVersion(), this.getSchemaLocation());
    }

    @Override
    public Element getElement() {
        return this.getRootElement();
    }

    @Override
    protected String getElementName() {
        return ENTITY_MAPPINGS;
    }

    @Override
    public ExternalEmbeddableEntity getEmbeddableEntity(int index) {
        Element element = this.getChild("embeddable", index);
        if (element == null) {
            return null;
        }
        return this.buildEmbeddableEntity(index);
    }

    @Override
    public ExternalEntity getEntity(int index) {
        Element element = this.getChild("entity", index);
        if (element == null) {
            return null;
        }
        return this.buildEntity(index);
    }

    @Override
    public ExternalEntity getEntity(String className) {
        for (ExternalEntity entity : this.entities()) {
            if (!ObjectTools.equals((Object)entity.getClassName(), (Object)className)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public ExternalMappedSuperClassEntity getMappedSuperClass(int index) {
        Element element = this.getChild("mapped-superclass", index);
        if (element == null) {
            return null;
        }
        return this.buildMappedSuperclass(index);
    }

    @Override
    public ExternalNativeQuery getNamedNativeQuery(int index) {
        Element element = this.getChild("named-native-query", index);
        if (element == null) {
            return null;
        }
        return this.buildNamedNativeQuery(index);
    }

    @Override
    public ExternalBasicNamedQuery getNamedQuery(int index) {
        Element element = this.getChild("named-query", index);
        if (element == null) {
            return null;
        }
        return this.buildNamedQuery(index);
    }

    @Override
    public ExternalBasicNamedQuery getNamedQuery(String queryName) {
        for (ExternalNamedQuery namedQuery : this.namedQueries()) {
            if (!namedQuery.getName().equals(queryName)) continue;
            return (ExternalBasicNamedQuery)namedQuery;
        }
        return null;
    }

    @Override
    public ExternalObjectTypeConverter getObjectTypeConverter(int index) {
        Element element = this.getChild("object-type-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildObjectTypeConverter(index);
    }

    @Override
    public String getPackageName() {
        return this.getChildTextNode(PACKAGE);
    }

    @Override
    public PersistenceUnit getPersistenceUnitMetaData() {
        Element element = this.getChild("persistence-unit-metadata");
        if (element == null) {
            return null;
        }
        return this.buildPersistenceUnit();
    }

    @Override
    public String getSchemaName() {
        return this.getChildTextNode(SCHEMA);
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator(int index) {
        Element element = this.getChild("sequence-generator", index);
        if (element == null) {
            return null;
        }
        return this.buildSequenceGenerator(index);
    }

    @Override
    public ExternalSQLResultSetMapping getSqlResultSetMapping(int index) {
        Element element = this.getChild("sql-result-set-mapping", index);
        if (element == null) {
            return null;
        }
        return this.buildSqlResultSetMapping(index);
    }

    @Override
    public ExternalStoredProcedureQuery getStoredProcedureQuery(int index) {
        Element element = this.getChild("named-stored-procedure-query", index);
        if (element == null) {
            return null;
        }
        return this.buildStoredProcedureQuery(index);
    }

    @Override
    public ExternalStoredProcedureQuery getStoredProcedureQuery(int index, String name) {
        ExternalStoredProcedureQuery storedProcedureQuery = this.getStoredProcedureQuery(index);
        if (storedProcedureQuery == null) {
            return null;
        }
        if (ObjectTools.notEquals((Object)name, (Object)storedProcedureQuery.getName())) {
            storedProcedureQuery = null;
        }
        return storedProcedureQuery;
    }

    @Override
    public ExternalStructConverter getStructConverter(int index) {
        Element element = this.getChild("struct-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildStructConverter(index);
    }

    @Override
    public ExternalTableGenerator getTableGenerator(int index) {
        Element element = this.getChild("table-generator", index);
        if (element == null) {
            return null;
        }
        return this.buildTableGenerator(index);
    }

    @Override
    public ExternalTypeConverter getTypeConverter(int index) {
        Element element = this.getChild("type-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildTypeConverter(index);
    }

    @Override
    public String getXML() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.getDocument());
            ByteArrayOutputStream ouput = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(ouput);
            transformer.transform(source, result);
            return ouput.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListIterable<ExternalMappedSuperClassEntity> mappedSuperClasses() {
        int count = this.mappedSuperClassesSize();
        ArrayList<MappedSuperClassEntity> entities = new ArrayList<MappedSuperClassEntity>(count);
        int index = count;
        while (--index >= 0) {
            MappedSuperClassEntity entity = this.buildMappedSuperclass(index);
            entities.add(0, entity);
        }
        return new ListListIterable(entities);
    }

    @Override
    public int mappedSuperClassesSize() {
        return this.getChildrenSize("mapped-superclass");
    }

    @Override
    public ListIterable<ExternalNativeQuery> namedNativeQueries() {
        int count = this.namedNativeQueriesSize();
        ArrayList<NamedNativeQuery> nativeQueries = new ArrayList<NamedNativeQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedNativeQuery nativeQuery = this.buildNamedNativeQuery(index);
            nativeQueries.add(0, nativeQuery);
        }
        return new ListListIterable(nativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.getChildrenSize("named-native-query");
    }

    @Override
    public ListIterable<ExternalNamedQuery> namedQueries() {
        int count = this.namedQueriesSize();
        ArrayList<NamedQuery> namedQueries = new ArrayList<NamedQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedQuery namedQuery = this.buildNamedQuery(index);
            namedQueries.add(0, namedQuery);
        }
        return new ListListIterable(namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.getChildrenSize("named-query");
    }

    @Override
    public ListIterable<ExternalObjectTypeConverter> objectTypeConverters() {
        int count = this.objectTypeConvertersSize();
        ArrayList<ObjectTypeConverter> converters = new ArrayList<ObjectTypeConverter>(count);
        int index = count;
        while (--index >= 0) {
            ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public int objectTypeConvertersSize() {
        return this.getChildrenSize("object-type-converter");
    }

    @Override
    public void removeConverter(int index) {
        Converter converter = this.buildConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removeDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
        column.removeSelf();
    }

    @Override
    public void removeEmbeddableEntity(int index) {
        EmbeddableEntity entity = this.buildEmbeddableEntity(index);
        entity.removeSelf();
    }

    @Override
    public void removeEntity(int index) {
        Entity entity = this.buildEntity(index);
        entity.removeSelf();
    }

    @Override
    public void removeEntity(String entityClassName) {
        for (ExternalEntity entity : this.entities()) {
            if (!entity.getClassName().equals(entityClassName)) continue;
            ((Entity)entity).removeSelf();
            return;
        }
    }

    @Override
    public void removeMappedSuperClass(int index) {
        MappedSuperClassEntity entity = this.buildMappedSuperclass(index);
        entity.removeSelf();
    }

    @Override
    public void removeNamedQuery(int index) {
        NamedQuery namedQuery = this.buildNamedQuery(index);
        namedQuery.removeSelf();
    }

    @Override
    public void removeNamedQuery(String queryName) {
        for (ExternalNamedQuery query : this.namedQueries()) {
            if (!query.getName().equals(queryName)) continue;
            ((NamedQuery)query).removeSelf();
            return;
        }
    }

    @Override
    public void removeNativeQuery(int index) {
        NamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(index);
        namedNativeQuery.removeSelf();
    }

    @Override
    public void removeObjectTypeConverter(int index) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removePersistenceUnitMetaData() {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit();
        persistenceUnit.removeSelf();
    }

    @Override
    public void removeSequenceGenerator(int index) {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator(index);
        sequenceGenerator.removeSelf();
    }

    @Override
    public void removeSqlResultSetMapping(int index) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.removeSelf();
    }

    @Override
    public void removeStoredProcedureQuery(int index) {
        NamedStoredProcedureQuery storedProcedureQuery = this.buildStoredProcedureQuery(index);
        storedProcedureQuery.removeSelf();
    }

    @Override
    public void removeStructConverter(int index) {
        StructConverter converter = this.buildStructConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removeTableGenerator(int index) {
        TableGenerator tableGenerator = this.buildTableGenerator(index);
        tableGenerator.removeSelf();
    }

    @Override
    public void removeTypeConverter(int index) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public ListIterable<ExternalSequenceGenerator> sequenceGenerators() {
        int count = this.sequenceGeneratorsSize();
        ArrayList<SequenceGenerator> sequenceGenerators = new ArrayList<SequenceGenerator>(count);
        int index = count;
        while (--index >= 0) {
            SequenceGenerator sequenceGenerator = this.buildSequenceGenerator(index);
            sequenceGenerators.add(0, sequenceGenerator);
        }
        return new ListListIterable(sequenceGenerators);
    }

    @Override
    public int sequenceGeneratorsSize() {
        return this.getChildrenSize("sequence-generator");
    }

    @Override
    public void setAccessType(AccessType type) {
        this.updateChildTextNode(ACCESS, (Enum<?>)type);
    }

    @Override
    public void setCatalogName(String catalog) {
        this.updateChildTextNode(CATALOG, catalog);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public void setDocumentType(ORMDocumentType version) {
        this.setVersion(version.getVersion());
        this.setSchemaLocation(this.buildSchemaLocation(version));
    }

    @Override
    public void setPackageName(String packageName) {
        this.updateChildTextNode(PACKAGE, packageName);
    }

    @Override
    public void setSchemaName(String schema) {
        this.updateChildTextNode(SCHEMA, schema);
    }

    @Override
    public ListIterable<ExternalSQLResultSetMapping> sqlResultSetMappings() {
        int count = this.sqlResultSetMappingsSize();
        ArrayList<SQLResultSetMapping> sqlResultSetMappings = new ArrayList<SQLResultSetMapping>(count);
        int index = count;
        while (--index >= 0) {
            SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
            sqlResultSetMappings.add(0, sqlResultSetMapping);
        }
        return new ListListIterable(sqlResultSetMappings);
    }

    @Override
    public int sqlResultSetMappingsSize() {
        return this.getChildrenSize("sql-result-set-mapping");
    }

    @Override
    public ListIterable<ExternalStoredProcedureQuery> storedProcedureQueries() {
        int count = this.storedProcedureQueriesSize();
        ArrayList<NamedStoredProcedureQuery> storedProcedureQueries = new ArrayList<NamedStoredProcedureQuery>(count);
        int index = count;
        while (--index >= 0) {
            NamedStoredProcedureQuery nativeQuery = this.buildStoredProcedureQuery(index);
            storedProcedureQueries.add(0, nativeQuery);
        }
        return new ListListIterable(storedProcedureQueries);
    }

    @Override
    public int storedProcedureQueriesSize() {
        return this.getChildrenSize("named-stored-procedure-query");
    }

    @Override
    public ListIterable<ExternalStructConverter> structConverters() {
        int count = this.structConvertersSize();
        ArrayList<StructConverter> converters = new ArrayList<StructConverter>(count);
        int index = count;
        while (--index >= 0) {
            StructConverter converter = this.buildStructConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public int structConvertersSize() {
        return this.getChildrenSize("struct-converter");
    }

    @Override
    public ListIterable<ExternalTableGenerator> tableGenerators() {
        int count = this.tableGeneratorsSize();
        ArrayList<TableGenerator> tableGenerators = new ArrayList<TableGenerator>(count);
        int index = count;
        while (--index >= 0) {
            TableGenerator tableGenerator = this.buildTableGenerator(index);
            tableGenerators.add(0, tableGenerator);
        }
        return new ListListIterable(tableGenerators);
    }

    @Override
    public int tableGeneratorsSize() {
        return this.getChildrenSize("table-generator");
    }

    @Override
    public ListIterable<ExternalTypeConverter> typeConverters() {
        int count = this.typeConvertersSize();
        ArrayList<TypeConverter> converters = new ArrayList<TypeConverter>(count);
        int index = count;
        while (--index >= 0) {
            TypeConverter converter = this.buildTypeConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public int typeConvertersSize() {
        return this.getChildrenSize("type-converter");
    }

    public class StringOutputStream
    extends OutputStream {
        private StringBuffer buffer = new StringBuffer();

        public void clear() {
            this.buffer.delete(0, this.buffer.length());
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public void write(int bt) throws IOException {
            this.buffer.append((char)bt);
        }
    }
}

