/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalOrderColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.OrderColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

abstract class ObjectCollectionMapping
extends RelationshipMapping
implements ExternalObjectCollectionMapping {
    static final String CLASS = "class";
    static final String MAP_KEY = "map-key";
    static final String MAP_KEY_ASSOCIATION_OVERRIDE = "map-key-association-override";
    static final String MAP_KEY_ATTRIBUTE_OVERRIDE = "map-key-attribute-override";
    static final String MAP_KEY_CLASS = "map-key-class";
    static final String MAP_KEY_COLUMN = "map-key-column";
    static final String MAP_KEY_CONVERT = "map-key-convert";
    static final String MAP_KEY_ENUMERATED = "map-key-enumerated";
    static final String MAP_KEY_JOIN_COLUMN = "map-key-join-column";
    static final String MAP_KEY_TEMPORAL = "map-key-temporal";
    static final String MAPPED_BY = "mapped-by";
    static final String ORDER_BY = "order-by";

    ObjectCollectionMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalAssociationOverride addMapKeyAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildMapKeyAssociationOverride(this.mapKeyAssociationOverridesSize());
        associationOverride.addSelf();
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addMapKeyAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(this.mapKeyAttributeOverridesSize());
        attributeOverride.addSelf();
        return attributeOverride;
    }

    @Override
    public void addMapKeyColumn() {
        EntityColumn column = this.buildColumn(MAP_KEY_COLUMN);
        column.addSelf();
    }

    @Override
    public void addMapKeyJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.addSelf();
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("access");
        names.add(MAPPED_BY);
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn(String elementName) {
        return new EntityColumn(this, elementName);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ORDER_BY);
        names.add("order-column");
        names.add(MAP_KEY);
        names.add(MAP_KEY_CLASS);
        names.add(MAP_KEY_COLUMN);
        names.add(MAP_KEY_JOIN_COLUMN);
        names.add("join-table");
        names.add("cascade");
        return names;
    }

    final JoinColumn buildJoinColumn(String elementName, int index) {
        return new JoinColumn(this, elementName, index);
    }

    private AssociationOverride buildMapKeyAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    private AttributeOverride buildMapKeyAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private OrderColumn buildOrderColumn() {
        return new OrderColumn(this);
    }

    @Override
    public String getMapKey() {
        return this.getChildAttribute(MAP_KEY, "name");
    }

    @Override
    public ExternalAssociationOverride getMapKeyAssociationOverride(int index) {
        Element element = this.getChild(MAP_KEY_ASSOCIATION_OVERRIDE, index);
        if (element == null) {
            return null;
        }
        return this.buildMapKeyAssociationOverride(index);
    }

    @Override
    public ExternalAttributeOverride getMapKeyAttributeOverride(int index) {
        Element element = this.getChild(MAP_KEY_ATTRIBUTE_OVERRIDE, index);
        if (element == null) {
            return null;
        }
        return this.buildMapKeyAttributeOverride(index);
    }

    @Override
    public String getMapKeyClassName() {
        return this.getChildAttribute(MAP_KEY_CLASS, CLASS);
    }

    @Override
    public ExternalEntityColumn getMapKeyColumn() {
        if (this.hasChild(MAP_KEY_COLUMN)) {
            return this.buildColumn(MAP_KEY_COLUMN);
        }
        return null;
    }

    @Override
    public String getMapKeyConverterName() {
        return this.getChildTextNode(MAP_KEY_CONVERT);
    }

    @Override
    public EnumType getMapKeyEnumeratedType() {
        return this.getChildEnumNode(MAP_KEY_ENUMERATED, EnumType.class);
    }

    @Override
    public ExternalJoinColumn getMapKeyJoinColumn(int index) {
        Element element = this.getChild(MAP_KEY_JOIN_COLUMN, index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.getChildEnumNode(MAP_KEY_TEMPORAL, TemporalType.class);
    }

    @Override
    public String getOrderByFieldName() {
        return this.getChildTextNode(ORDER_BY);
    }

    @Override
    public ExternalOrderColumn getOrderColumn() {
        if (this.hasChild("order-column")) {
            return this.buildOrderColumn();
        }
        return null;
    }

    @Override
    public ListIterable<ExternalAssociationOverride> mapKeyAssociationOverrides() {
        int count = this.mapKeyAssociationOverridesSize();
        ArrayList<AssociationOverride> associationOverrides = new ArrayList<AssociationOverride>(count);
        int index = count;
        while (--index >= 0) {
            AssociationOverride associationOverride = this.buildMapKeyAssociationOverride(index);
            associationOverrides.add(0, associationOverride);
        }
        return new ListListIterable(associationOverrides);
    }

    @Override
    public int mapKeyAssociationOverridesSize() {
        return this.getChildrenSize(MAP_KEY_ASSOCIATION_OVERRIDE);
    }

    @Override
    public ListIterable<ExternalAttributeOverride> mapKeyAttributeOverrides() {
        int count = this.mapKeyAttributeOverridesSize();
        ArrayList<AttributeOverride> attributeOverrides = new ArrayList<AttributeOverride>(count);
        int index = count;
        while (--index >= 0) {
            AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(index);
            attributeOverrides.add(0, attributeOverride);
        }
        return new ListListIterable(attributeOverrides);
    }

    @Override
    public int mapKeyAttributeOverridesSize() {
        return this.getChildrenSize(MAP_KEY_ATTRIBUTE_OVERRIDE);
    }

    @Override
    public ListIterable<ExternalJoinColumn> mapKeyJoinColumns() {
        int count = this.mapKeyJoinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int mapKeyJoinColumnsSize() {
        return this.getChildrenSize(MAP_KEY_JOIN_COLUMN);
    }

    @Override
    public void removeMapKeyAssociationOverride(int index) {
        AssociationOverride joinColumn = this.buildMapKeyAssociationOverride(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeMapKeyAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void removeMapKeyColumn() {
        EntityColumn column = this.buildColumn(MAP_KEY_COLUMN);
        column.removeSelf();
    }

    @Override
    public void removeMapKeyJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.removeSelf();
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setMapKey(String mapKey) {
        if (mapKey == null) {
            this.removeChild(MAP_KEY);
        } else {
            Element element = this.getChild(MAP_KEY);
            if (element == null) {
                element = this.addChild(MAP_KEY);
            }
            this.setAttribute(element, "name", mapKey);
        }
    }

    @Override
    public void setMapKeyClassName(String className) {
        if (className == null) {
            this.removeChild(MAP_KEY_CLASS);
        } else {
            Element element = this.getChild(MAP_KEY_CLASS);
            if (element == null) {
                element = this.addChild(MAP_KEY_CLASS);
            }
            this.setAttribute(element, CLASS, className);
        }
    }

    @Override
    public void setMapKeyConverterName(String converterName) {
        this.updateChildTextNode(MAP_KEY_CONVERT, converterName);
    }

    @Override
    public void setMapKeyEnumeratedType(EnumType enumType) {
        this.updateChildTextNode(MAP_KEY_ENUMERATED, (Enum<?>)enumType);
    }

    @Override
    public void setMapKeyTemporalType(TemporalType temporalType) {
        this.updateChildTextNode(MAP_KEY_TEMPORAL, (Enum<?>)temporalType);
    }

    @Override
    public void setOrderByFieldName(String name) {
        this.updateChildTextNode(ORDER_BY, name);
    }
}

