/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.uitools.GlobalAWTExceptionHandler;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.ExceptionHandlerThreadGroup;
import org.eclipse.persistence.tools.workbench.utility.ExceptionListener;
import org.eclipse.persistence.tools.workbench.utility.SimpleExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.log.LoggingExceptionListener;

public class Main {
    public static void main(String[] args) {
        new Main().execute(args);
    }

    private Main() {
    }

    private void execute(String[] args) {
        File projectFile = this.projectFile(args);
        boolean developmentMode = this.developmentMode(args);
        Logger logger = this.buildLogger();
        LoggingExceptionListener listener = new LoggingExceptionListener(logger, Level.SEVERE, "UNEXPECTED_EXCEPTION");
        SimpleExceptionBroadcaster broadcaster = new SimpleExceptionBroadcaster();
        broadcaster.addExceptionListener((ExceptionListener)listener);
        ExceptionHandlerThreadGroup threadGroup = new ExceptionHandlerThreadGroup("application", (ExceptionBroadcaster)broadcaster);
        GlobalAWTExceptionHandler.register((ExceptionBroadcaster)broadcaster);
        Preferences preferences = this.buildPreferences();
        new Thread((ThreadGroup)threadGroup, new ApplicationLauncher(logger, preferences, projectFile, developmentMode), "Main").start();
    }

    private File projectFile(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            int j;
            String arg = args[i];
            if (!arg.toLowerCase().equals("-open") || (j = i + 1) >= args.length) continue;
            return new File(args[j]);
        }
        return null;
    }

    private boolean developmentMode(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.toLowerCase().equals("-dev")) continue;
            return true;
        }
        return false;
    }

    private Logger buildLogger() {
        Logger logger = Logger.getLogger(this.buildLoggerName(), FrameworkApplication.getResourceBundleName());
        return logger;
    }

    private String buildLoggerName() {
        return ClassTools.packageNameFor(this.getClass());
    }

    private Preferences buildPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        return preferences;
    }

    private static class ApplicationLauncher
    implements Runnable {
        private Logger logger;
        private Preferences preferences;
        private File projectFile;
        private boolean developmentMode;

        ApplicationLauncher(Logger logger, Preferences preferences, File projectFile, boolean developmentMode) {
            this.logger = logger;
            this.preferences = preferences;
            this.projectFile = projectFile;
            this.developmentMode = developmentMode;
        }

        @Override
        public void run() {
            FrameworkApplication.launch(this.logger, this.preferences, this.projectFile, this.developmentMode);
        }
    }
}

