/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;

public final class FullyQualifyPathExpressionVisitor
extends AbstractTraverseChildrenVisitor {
    private String variableName;
    private GeneralIdentificationVariableVisitor visitor;

    private GeneralIdentificationVariableVisitor generalIdentificationVariableVisitor() {
        if (this.visitor == null) {
            this.visitor = new GeneralIdentificationVariableVisitor();
        }
        return this.visitor;
    }

    public void visit(AbstractSchemaName expression) {
        this.variableName = expression.toActualText().toLowerCase();
    }

    public void visit(CollectionMemberDeclaration expression) {
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(DeleteClause expression) {
        expression.getRangeVariableDeclaration().accept(this);
    }

    public void visit(DeleteStatement expression) {
        expression.getDeleteClause().accept(this);
        if (this.variableName != null && expression.hasWhereClause()) {
            expression.getWhereClause().accept(this);
        }
    }

    public void visit(IdentificationVariable expression) {
        expression.setVirtualIdentificationVariable(this.variableName);
    }

    public void visit(Join expression) {
    }

    public void visit(RangeVariableDeclaration expression) {
        if (!expression.hasIdentificationVariable()) {
            expression.getRootObject().accept(this);
            expression.setVirtualIdentificationVariable(this.variableName);
        }
    }

    public void visit(SelectStatement expression) {
    }

    public void visit(SimpleSelectStatement expression) {
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    public void visit(UpdateClause expression) {
        expression.getRangeVariableDeclaration().accept(this);
        if (this.variableName != null && expression.hasUpdateItems()) {
            expression.getUpdateItems().accept(this);
        }
    }

    public void visit(UpdateStatement expression) {
        expression.getUpdateClause().accept(this);
        if (this.variableName != null && expression.hasWhereClause()) {
            expression.getWhereClause().accept(this);
        }
    }

    private void visitAbstractPathExpression(AbstractPathExpression expression) {
        if (!expression.startsWithDot()) {
            GeneralIdentificationVariableVisitor visitor = this.generalIdentificationVariableVisitor();
            expression.getIdentificationVariable().accept(visitor);
            if (visitor.expression == null) {
                expression.setVirtualIdentificationVariable(this.variableName);
            }
        }
    }

    private class GeneralIdentificationVariableVisitor
    extends AbstractExpressionVisitor {
        private Expression expression;

        private GeneralIdentificationVariableVisitor() {
        }

        public void visit(EntryExpression expression) {
            this.expression = expression;
        }

        public void visit(KeyExpression expression) {
            this.expression = expression;
        }

        public void visit(ValueExpression expression) {
            this.expression = expression;
        }
    }
}

