/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DiffEngine
implements Differentiator {
    private final RecordingDifferentiator recordingDifferentiator = new RecordingDifferentiator();
    private final Map userDifferentiators = new HashMap();
    private final Map reflectiveDifferentiatorCache;
    private final Map differentiatorCache;
    private boolean diffInProgress;
    private Log log;
    private static final Class OBJECT_CLASS = Object.class;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public DiffEngine() {
        this.userDifferentiators.put(OBJECT_CLASS, EqualityDifferentiator.instance());
        this.reflectiveDifferentiatorCache = new HashMap();
        this.differentiatorCache = new HashMap();
        this.diffInProgress = false;
        this.log = Log.NULL_INSTANCE;
    }

    @Override
    public synchronized Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.NORMAL);
    }

    @Override
    public synchronized Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object1, Object object2, DifferentiatorAdapter adapter) {
        this.setUp();
        Diff diff = adapter.diff(this.recordingDifferentiator, object1, object2);
        this.tearDown();
        return diff;
    }

    @Override
    public boolean comparesValueObjects() {
        return false;
    }

    Differentiator differentiatorFor(Object object) {
        return this.differentiatorForClass(object == null ? OBJECT_CLASS : object.getClass());
    }

    private Differentiator differentiatorForClass(Class javaClass) {
        Differentiator differentiator = (Differentiator)this.differentiatorCache.get(javaClass);
        if (differentiator != null) {
            return differentiator;
        }
        for (Class tempClass = javaClass; tempClass != null; tempClass = tempClass.getSuperclass()) {
            differentiator = (Differentiator)this.userDifferentiators.get(tempClass);
            if (differentiator == null) continue;
            if (differentiator instanceof ReflectiveDifferentiator) {
                this.expandReflectiveDifferentiatorCache(javaClass, differentiator.comparesValueObjects());
                return (Differentiator)this.differentiatorCache.get(javaClass);
            }
            this.differentiatorCache.put(javaClass, differentiator);
            return differentiator;
        }
        throw new IllegalStateException("missing differentiator: " + javaClass.getName());
    }

    public synchronized Differentiator getUserDifferentiator(Class javaClass) {
        return (Differentiator)this.userDifferentiators.get(javaClass);
    }

    public synchronized Differentiator getDefaultDifferentiator() {
        return (Differentiator)this.userDifferentiators.get(OBJECT_CLASS);
    }

    public synchronized Differentiator getRecordingDifferentiator() {
        return this.recordingDifferentiator;
    }

    private void setUp() {
        if (this.diffInProgress) {
            throw new IllegalStateException("Recursive calls to a DiffEngine are not allowed.");
        }
        this.diffInProgress = true;
        this.checkUserReflectiveDifferentiators();
        this.expandReflectiveDifferentiatorCache();
        this.recordingDifferentiator.setUp();
    }

    private void checkUserReflectiveDifferentiators() {
        for (Map.Entry entry : this.userDifferentiators.entrySet()) {
            Class javaClass = (Class)entry.getKey();
            Differentiator differentiator = (Differentiator)entry.getValue();
            if (differentiator instanceof ReflectiveDifferentiator) {
                this.checkUserReflectiveDifferentiator(javaClass.getSuperclass());
                this.reflectiveDifferentiatorCache.put(javaClass, differentiator);
                continue;
            }
            this.differentiatorCache.put(javaClass, differentiator);
        }
    }

    private void checkUserReflectiveDifferentiator(Class javaClass) {
        if (javaClass == OBJECT_CLASS) {
            return;
        }
        Differentiator differentiator = (Differentiator)this.userDifferentiators.get(javaClass);
        if (differentiator != null && !(differentiator instanceof ReflectiveDifferentiator)) {
            throw new IllegalStateException("The differentiator for " + javaClass.getName() + " must be reflective: " + differentiator);
        }
        this.checkUserReflectiveDifferentiator(javaClass.getSuperclass());
    }

    private void expandReflectiveDifferentiatorCache() {
        for (Map.Entry entry : new HashMap(this.reflectiveDifferentiatorCache).entrySet()) {
            Class javaClass = (Class)entry.getKey();
            boolean comparesValueObjects = ((ReflectiveDifferentiator)entry.getValue()).comparesValueObjects();
            this.expandReflectiveDifferentiatorCache(javaClass, comparesValueObjects);
        }
    }

    private void expandReflectiveDifferentiatorCache(Class javaClass, boolean comparesValueObjects) {
        if (javaClass == OBJECT_CLASS) {
            return;
        }
        ReflectiveDifferentiator rd = (ReflectiveDifferentiator)this.reflectiveDifferentiatorCache.get(javaClass);
        if (rd == null) {
            rd = new ReflectiveDifferentiator(javaClass, this.recordingDifferentiator);
            rd.setComparesValueObjects(comparesValueObjects);
            this.reflectiveDifferentiatorCache.put(javaClass, rd);
        }
        this.expandReflectiveDifferentiatorCache(javaClass.getSuperclass(), comparesValueObjects);
        this.setUpDifferentiatorCache(javaClass);
    }

    private void setUpDifferentiatorCache(Class javaClass) {
        if (this.differentiatorCache.get(javaClass) != null) {
            return;
        }
        ArrayList differentiators = new ArrayList();
        for (Class tempClass = javaClass; tempClass != OBJECT_CLASS; tempClass = tempClass.getSuperclass()) {
            differentiators.add(this.reflectiveDifferentiatorCache.get(tempClass));
        }
        Differentiator differentiator = null;
        differentiator = differentiators.size() == 1 ? (Differentiator)differentiators.get(0) : new CompositeDifferentiator(CollectionTools.reverse(differentiators));
        this.differentiatorCache.put(javaClass, differentiator);
    }

    public synchronized void setDefaultDifferentiator(Differentiator defaultDifferentiator) {
        this.userDifferentiators.put(OBJECT_CLASS, defaultDifferentiator);
    }

    public synchronized Differentiator setUserDifferentiator(Class javaClass, Differentiator userDifferentiator) {
        if (userDifferentiator == null) {
            throw new NullPointerException();
        }
        if (this.userDifferentiators.put(javaClass, userDifferentiator) != null) {
            throw new IllegalArgumentException("duplicate differentiator: " + javaClass.getName());
        }
        return userDifferentiator;
    }

    public synchronized Differentiator removeUserDifferentiator(Class javaClass) {
        if (javaClass == OBJECT_CLASS) {
            throw new IllegalArgumentException("The differentiator for java.lang.Object cannot be removed.");
        }
        return (Differentiator)this.userDifferentiators.remove(javaClass);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass) {
        return this.addReflectiveDifferentiator(javaClass, EMPTY_STRING_ARRAY);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String ignoredFieldName) {
        return this.addReflectiveDifferentiator(javaClass, new String[]{ignoredFieldName});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String ignoredFieldName1, String ignoredFieldName2) {
        return this.addReflectiveDifferentiator(javaClass, new String[]{ignoredFieldName1, ignoredFieldName2});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String ignoredFieldName1, String ignoredFieldName2, String ignoredFieldName3) {
        return this.addReflectiveDifferentiator(javaClass, new String[]{ignoredFieldName1, ignoredFieldName2, ignoredFieldName3});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String ignoredFieldName1, String ignoredFieldName2, String ignoredFieldName3, String ignoredFieldName4) {
        return this.addReflectiveDifferentiator(javaClass, new String[]{ignoredFieldName1, ignoredFieldName2, ignoredFieldName3, ignoredFieldName4});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String[] ignoredFieldNames) {
        return this.addReflectiveDifferentiator(javaClass, ignoredFieldNames, EMPTY_STRING_ARRAY);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class javaClass, String[] ignoredFieldNames, String[] keyFieldNames) {
        ReflectiveDifferentiator rd = new ReflectiveDifferentiator(javaClass, this.recordingDifferentiator);
        rd.ignoreFieldsNamed(ignoredFieldNames);
        rd.addKeyFieldsNamed(keyFieldNames);
        this.setUserDifferentiator(javaClass, rd);
        return rd;
    }

    public void setLog(String fileName) throws FileNotFoundException {
        this.setLog(new WriterLog(fileName));
    }

    public void setLog(Log log) {
        this.log = log;
    }

    void log(Diff diff) {
        this.log.log(diff);
    }

    private void tearDown() {
        this.recordingDifferentiator.tearDown();
        this.differentiatorCache.clear();
        this.reflectiveDifferentiatorCache.clear();
        this.diffInProgress = false;
        this.log.close();
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    private class RecordingDifferentiator
    implements Differentiator {
        private IdentityHashMap previousDiffs1 = new IdentityHashMap();
        private IdentityHashMap previousDiffs2 = new IdentityHashMap();

        RecordingDifferentiator() {
        }

        @Override
        public Diff diff(Object object1, Object object2) {
            Differentiator differentiator = DiffEngine.this.differentiatorFor(object1);
            if (!differentiator.comparesValueObjects()) {
                this.checkDiff(object1, this.previousDiffs1);
                this.checkDiff(object2, this.previousDiffs2);
            }
            Diff diff = differentiator.diff(object1, object2);
            DiffEngine.this.log(diff);
            return diff;
        }

        @Override
        public Diff keyDiff(Object object1, Object object2) {
            Differentiator differentiator = DiffEngine.this.differentiatorFor(object1);
            Diff diff = differentiator.keyDiff(object1, object2);
            DiffEngine.this.log(diff);
            return diff;
        }

        @Override
        public boolean comparesValueObjects() {
            return false;
        }

        void setUp() {
        }

        private void checkDiff(Object object, IdentityHashMap previousDiffs) {
            Object prev = previousDiffs.put(object, object);
            if (prev != null) {
                throw new IllegalArgumentException("duplicate diff: " + object);
            }
        }

        void tearDown() {
            this.previousDiffs1.clear();
            this.previousDiffs2.clear();
        }

        public String toString() {
            return StringTools.buildToStringFor(this);
        }
    }

    public static class WriterLog
    implements Log {
        private IndentingPrintWriter writer;
        private boolean logsValueDiffs;

        public WriterLog() {
            this(System.out);
        }

        public WriterLog(String fileName) throws FileNotFoundException {
            this(new File(fileName));
        }

        public WriterLog(File file) throws FileNotFoundException {
            this(new FileOutputStream(file));
        }

        public WriterLog(OutputStream stream) {
            this(new OutputStreamWriter(stream));
        }

        public WriterLog(Writer writer) {
            this(new IndentingPrintWriter(new BufferedWriter(writer, 32768)));
        }

        public WriterLog(IndentingPrintWriter writer) {
            this.writer = writer;
            this.logsValueDiffs = false;
        }

        @Override
        public void log(Diff diff) {
            if (diff.getDifferentiator().comparesValueObjects() && !this.logsValueDiffs) {
                return;
            }
            if (diff.identical()) {
                this.writer.println("<no difference>");
                this.writer.print("object 1: ");
                this.writer.println(diff.getObject1());
                this.writer.print("object 2: ");
                this.writer.println(diff.getObject2());
            } else {
                diff.appendDescription(this.writer);
            }
            this.writer.println();
        }

        @Override
        public void close() {
            this.writer.close();
        }

        public boolean logsValueDiffs() {
            return this.logsValueDiffs;
        }

        public void setLogsValueDiffs(boolean logsValueDiffs) {
            this.logsValueDiffs = logsValueDiffs;
        }
    }

    public static interface Log {
        public static final Log NULL_INSTANCE = new Log(){

            @Override
            public void log(Diff diff) {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "NullLog";
            }
        };

        public void log(Diff var1);

        public void close();
    }
}

