/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.EclipseLinkVersion;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.tools.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Declaration;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected AcceptableTypeVisitor buildAcceptableTypeVisitor() {
        return new AcceptableTypeVisitor();
    }

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor();
    }

    protected EndingQueryPositionBuilder buildEndingQueryPositionBuilder() {
        return new EndingQueryPositionBuilder();
    }

    protected FollowingClausesVisitor buildFollowingClausesVisitor() {
        return new FollowingClausesVisitor();
    }

    protected FromClauseCollectionHelper buildFromClauseCollectionHelper() {
        return new FromClauseCollectionHelper();
    }

    protected FromClauseStatementHelper buildFromClauseStatementHelper() {
        return new FromClauseStatementHelper();
    }

    protected AbstractContentAssistVisitor.GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new AbstractContentAssistVisitor.GroupByClauseCollectionHelper(this);
    }

    protected IncompleteCollectionExpressionVisitor buildIncompleteCollectionExpressionVisitor() {
        return new IncompleteCollectionExpressionVisitor();
    }

    protected OrderByClauseStatementHelper buildOrderByClauseStatementHelper() {
        return new OrderByClauseStatementHelper();
    }

    protected SimpleFromClauseStatementHelper buildSimpleFromClauseStatementHelper() {
        return new SimpleFromClauseStatementHelper();
    }

    protected TableExpressionVisitor buildTableExpressionVisitor() {
        return new TableExpressionVisitor();
    }

    protected UnionClauseStatementHelper buildUnionClauseStatementHelper() {
        return new UnionClauseStatementHelper();
    }

    protected EclipseLinkVersion getEcliseLinkVersion() {
        return EclipseLinkVersion.value(this.queryContext.getProviderVersion());
    }

    protected JPQLGrammar getLatestGrammar() {
        return DefaultEclipseLinkJPQLGrammar.instance();
    }

    protected TableExpressionVisitor getTableExpressionVisitor() {
        TableExpressionVisitor visitor = this.getHelper(TableExpressionVisitor.class);
        if (visitor == null) {
            visitor = this.buildTableExpressionVisitor();
            this.registerHelper(TableExpressionVisitor.class, visitor);
        }
        return visitor;
    }

    protected String getTableName(String variableName) {
        Expression baseExpression;
        Declaration declaration = this.queryContext.getDeclaration(variableName);
        Expression expression = baseExpression = declaration != null ? declaration.getBaseExpression() : null;
        if (baseExpression != null && this.isTableExpression(baseExpression)) {
            return this.queryContext.literal(baseExpression, LiteralType.STRING_LITERAL);
        }
        return null;
    }

    protected UnionClauseStatementHelper getUnionClauseStatementHelper() {
        UnionClauseStatementHelper helper = this.getHelper(UnionClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildUnionClauseStatementHelper();
            this.registerHelper(UnionClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected void initialize() {
        super.initialize();
        this.identifierFilters.put("REGEXP", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("!=", VALID_IDENTIFIER_FILTER);
    }

    protected boolean isJoinFetchIdentifiable() {
        EclipseLinkVersion version = EclipseLinkVersion.value(this.queryContext.getProviderVersion());
        return version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
    }

    protected boolean isTableExpression(Expression expression) {
        TableExpressionVisitor visitor = this.getTableExpressionVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
            visitor.expression = null;
        }
    }

    public void visit(AsOfClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, "AS OF")) {
            this.proposals.addIdentifier("AS OF");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = "AS OF".length() + 1;
            if (position == length) {
                this.addIdentifier("SCN");
                this.addIdentifier("TIMESTAMP");
                if (!expression.hasScn() && !expression.hasTimestamp()) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("scalar_expression");
                }
            } else if (expression.hasScn() || expression.hasSpaceAfterIdentifier()) {
                if (expression.hasScn() && this.isPositionWithin(position, length, "SCN")) {
                    this.proposals.addIdentifier("SCN");
                    this.proposals.addIdentifier("TIMESTAMP");
                } else if (expression.hasTimestamp() && this.isPositionWithin(position, length, "TIMESTAMP")) {
                    this.proposals.addIdentifier("SCN");
                    this.proposals.addIdentifier("TIMESTAMP");
                } else {
                    if (expression.hasScn()) {
                        length += "SCN".length();
                    } else if (expression.hasTimestamp()) {
                        length += "TIMESTAMP".length();
                    }
                    if (expression.hasSpaceAfterCategory()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers("scalar_expression");
                    }
                }
            }
        }
    }

    public void visit(CastExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.addIdentifier(identifier);
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis()) {
            Expression scalarExpression;
            int length = identifier.length() + 1;
            if (position == length) {
                this.addIdentificationVariables();
                this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
            } else if (expression.hasExpression() && this.isComplete(scalarExpression = expression.getExpression())) {
                length += scalarExpression.getLength();
                if (expression.hasSpaceAfterExpression()) {
                    if (position == ++length) {
                        this.addAggregateIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
                        this.proposals.addIdentifier("AS");
                    } else if (this.isPositionWithin(position, length, "AS")) {
                        this.proposals.addIdentifier("AS");
                    }
                }
            }
        }
    }

    public void visit(ConnectByClause expression) {
        int length;
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, "CONNECT BY")) {
            this.proposals.addIdentifier("CONNECT BY");
        } else if (expression.hasSpaceAfterConnectBy() && position == (length = "CONNECT BY".length() + 1)) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers("collection_valued_path_expression");
        }
    }

    public void visit(DatabaseType expression) {
        super.visit(expression);
    }

    public void visit(ExtractExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
            this.addFunctionIdentifiers(expression);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            if (expression.hasDatePart()) {
                String datePart = expression.getDatePart();
                this.isPositionWithin(position, length, datePart);
                length += datePart.length();
                if (expression.hasSpaceAfterDatePart() && position == ++length) {
                    this.addIdentifier("FROM");
                    if (!expression.hasExpression() || !expression.hasFrom()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
                    }
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.proposals.addIdentifier("FROM");
                    if (!expression.hasExpression()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
                    }
                }
                length += 4;
                if (expression.hasSpaceAfterFrom()) {
                    ++length;
                }
                if (position == length) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
                }
            }
        }
    }

    public void visit(HierarchicalQueryClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        if (position == 0) {
            this.addIdentifier("START WITH");
            if (!expression.hasStartWithClause()) {
                this.addIdentifier("CONNECT BY");
            }
        } else {
            int length = 0;
            if (expression.hasStartWithClause()) {
                if (this.hasVirtualSpace() && position == (length += expression.getStartWithClause().getLength()) + 1) {
                    this.addIdentifier("CONNECT BY");
                } else if (expression.hasSpaceAfterStartWithClause() && position == ++length) {
                    this.addIdentifier("CONNECT BY");
                }
            }
            if (this.hasVirtualSpace() && position == (length += expression.getConnectByClause().getLength()) + 1) {
                this.addIdentifier("ORDER SIBLINGS BY");
            } else if (expression.hasSpaceAfterConnectByClause() && position == ++length) {
                this.addIdentifier("ORDER SIBLINGS BY");
            }
        }
    }

    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasExpression()) {
            int length = expression.getExpression().getLength();
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    if (expression.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    }
                } else if (position > (length += expression.getActualOrdering().length()) && expression.hasSpaceAfterOrdering()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    } else {
                        String nullOrdering = expression.getActualNullOrdering();
                        if (this.isPositionWithin(position, length, nullOrdering)) {
                            this.proposals.addIdentifier("NULLS FIRST");
                            this.proposals.addIdentifier("NULLS LAST");
                        }
                    }
                }
            }
        }
    }

    public void visit(OrderSiblingsByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "ORDER SIBLINGS BY", this.getOrderByClauseCollectionHelper());
        }
    }

    public void visit(RegexpExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += expression.getStringExpression().getLength();
            if (expression.hasSpaceAfterStringExpression()) {
                ++length;
            }
        }
        if (this.isPositionWithin(position, length, "REGEXP")) {
            this.proposals.addIdentifier("REGEXP");
        } else {
            length += 6;
            if (expression.hasSpaceAfterIdentifier()) {
                ++length;
                this.addIdentificationVariables();
                this.addFunctionIdentifiers("pattern_value");
            }
        }
    }

    public void visit(StartWithClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, expression.getIdentifier(), this.getConditionalClauseCollectionHelper());
        }
    }

    public void visit(TableExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression);
        if (this.isPositionWithin(position, "TABLE")) {
            this.proposals.addIdentifier("TABLE");
        } else if (expression.hasLeftParenthesis()) {
            int length = "TABLE".length() + 1;
            if (position == length) {
                this.proposals.setTableNamePrefix("");
            } else {
                Expression nameExpression = expression.getExpression();
                String tableName = this.queryContext.literal(nameExpression, LiteralType.STRING_LITERAL);
                if (tableName.length() == 0) {
                    tableName = this.queryContext.literal(nameExpression, LiteralType.IDENTIFICATION_VARIABLE);
                }
                int tableNameLength = tableName.length();
                if (position > length && position <= length + tableNameLength) {
                    String prefix = tableName.substring(0, position - length);
                    prefix = ExpressionTools.unquote(prefix);
                    this.proposals.setTableNamePrefix(prefix);
                }
            }
        }
    }

    public void visit(TableVariableDeclaration expression) {
        super.visit(expression);
        TableExpression tableExpression = expression.getTableExpression();
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        int length = tableExpression.getLength();
        if (expression.hasSpaceAfterTableExpression() && this.isPositionWithin(position, ++length, "AS") && this.isComplete(tableExpression)) {
            this.addIdentifier("AS");
        }
    }

    public void visit(UnionClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier("EXCEPT");
            this.proposals.addIdentifier("INTERSECT");
            this.proposals.addIdentifier("UNION");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = identifier.length() + 1;
            if (position == length) {
                this.proposals.addIdentifier("ALL");
                if (!expression.hasAll()) {
                    this.addIdentifier("SELECT");
                }
            } else if (this.isPositionWithin(position, length, "ALL")) {
                this.addIdentifier("ALL");
            } else if (position == length && !expression.hasAll()) {
                this.proposals.addIdentifier("SELECT");
            } else {
                if (expression.hasAll()) {
                    length += 3;
                }
                if (expression.hasSpaceAfterAll() && position == ++length) {
                    this.proposals.addIdentifier("SELECT");
                }
            }
        }
    }

    protected void visitThirdPartyPathExpression(AbstractPathExpression expression, String variableName) {
        String tableName;
        int secondDotIndex;
        int position = this.queryPosition.getPosition(expression);
        String text = expression.toActualText();
        int dotIndex = text.indexOf(46);
        int n = secondDotIndex = dotIndex > -1 ? text.indexOf(46, dotIndex + 1) : -1;
        if ((secondDotIndex == -1 || position < secondDotIndex) && (tableName = this.getTableName(variableName)) != "") {
            tableName = ExpressionTools.unquote(tableName);
            this.proposals.setTableName(tableName, text.substring(dotIndex + 1, position));
        }
    }

    protected class AcceptableTypeVisitor
    extends AbstractContentAssistVisitor.AcceptableTypeVisitor {
        protected AcceptableTypeVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }
    }

    protected class AppendableExpressionVisitor
    extends AbstractContentAssistVisitor.AppendableExpressionVisitor
    implements EclipseLinkExpressionVisitor {
        protected AppendableExpressionVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void visit(AsOfClause expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(CastExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        public void visit(ConnectByClause expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        public void visit(HierarchicalQueryClause expression) {
            if (expression.hasOrderSiblingsByClause()) {
                expression.getOrderSiblingsByClause().accept(this);
            } else if (expression.hasConnectByClause()) {
                expression.getConnectByClause().accept(this);
            } else if (expression.hasStartWithClause()) {
                expression.getStartWithClause().accept(this);
            }
        }

        public void visit(OrderSiblingsByClause expression) {
            if (expression.hasOrderByItems()) {
                this.clauseOfItems = true;
                expression.getOrderByItems().accept(this);
                this.clauseOfItems = false;
            }
        }

        public void visit(RegexpExpression expression) {
            if (expression.hasPatternValue()) {
                expression.getPatternValue().accept(this);
            }
        }

        public void visit(StartWithClause expression) {
            if (expression.hasConditionalExpression()) {
                this.conditionalExpression = true;
                expression.getConditionalExpression().accept(this);
                this.conditionalExpression = false;
            }
        }

        public void visit(TableExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        public void visit(TableVariableDeclaration expression) {
            if (expression.hasIdentificationVariable()) {
                expression.getIdentificationVariable().accept(this);
            }
        }

        public void visit(UnionClause expression) {
            if (expression.hasQuery()) {
                expression.getQuery().accept(this);
            }
        }
    }

    protected class EndingQueryPositionBuilder
    extends AbstractContentAssistVisitor.EndingQueryPositionBuilder
    implements EclipseLinkExpressionVisitor {
        protected EndingQueryPositionBuilder() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void visit(AsOfClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(CastExpression expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasScalarExpression() && !expression.hasAs() && !expression.hasDatabaseType() && !expression.hasRightParenthesis()) {
                expression.getExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(ConnectByClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(DatabaseType expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(ExtractExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(HierarchicalQueryClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasOrderSiblingsByClause()) {
                expression.getOrderSiblingsByClause().accept(this);
            } else if (expression.hasConnectByClause()) {
                expression.getConnectByClause().accept(this);
                if (expression.hasSpaceAfterConnectByClause()) {
                    this.virtualSpace = true;
                }
            } else if (expression.hasStartWithClause()) {
                expression.getStartWithClause().accept(this);
                if (expression.hasSpaceAfterStartWithClause()) {
                    this.virtualSpace = true;
                }
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(OrderSiblingsByClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasOrderByItems()) {
                expression.getOrderByItems().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(RegexpExpression expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasPatternValue()) {
                expression.getPatternValue().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(StartWithClause expression) {
            this.visitAbstractConditionalClause(expression);
        }

        public void visit(TableExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(TableVariableDeclaration expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasIdentificationVariable()) {
                expression.getIdentificationVariable().accept(this);
            } else if (!expression.hasAs()) {
                expression.getTableExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(UnionClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasQuery()) {
                expression.getQuery().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }
    }

    protected class FollowingClausesVisitor
    extends AbstractContentAssistVisitor.FollowingClausesVisitor {
        protected boolean hasAsOfClause;
        protected boolean hasConnectByClause;
        protected boolean hasOrderSiblingsByClause;
        protected boolean hasStartWithClause;
        protected boolean introspect;

        protected FollowingClausesVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void dispose() {
            super.dispose();
            this.hasAsOfClause = false;
            this.hasConnectByClause = false;
            this.hasStartWithClause = false;
            this.hasOrderSiblingsByClause = false;
        }

        protected boolean hasFromClause(AbstractSelectStatement expression) {
            this.introspect = true;
            expression.getFromClause().accept(this);
            this.introspect = false;
            if (this.afterIdentifier == "SELECT") {
                if (this.beforeIdentifier == "START WITH") {
                    return expression.hasFromClause();
                }
                if (this.beforeIdentifier == "CONNECT BY") {
                    return expression.hasFromClause() || this.hasStartWithClause;
                }
                if (this.beforeIdentifier == "ORDER SIBLINGS BY") {
                    return expression.hasFromClause() || this.hasStartWithClause || this.hasConnectByClause;
                }
                if (this.beforeIdentifier == "AS OF") {
                    return expression.hasFromClause() || this.hasStartWithClause || this.hasConnectByClause || this.hasOrderSiblingsByClause;
                }
                if (this.beforeIdentifier == "WHERE") {
                    return expression.hasFromClause() || this.hasStartWithClause || this.hasConnectByClause || this.hasOrderSiblingsByClause || this.hasAsOfClause;
                }
            } else if (this.afterIdentifier == "FROM") {
                if (this.beforeIdentifier == "CONNECT BY") {
                    return this.hasStartWithClause;
                }
                if (this.beforeIdentifier == "ORDER SIBLINGS BY") {
                    return this.hasStartWithClause || this.hasConnectByClause;
                }
                if (this.beforeIdentifier == "AS OF") {
                    return this.hasStartWithClause || this.hasConnectByClause || this.hasOrderSiblingsByClause;
                }
                if (this.beforeIdentifier == "WHERE") {
                    return this.hasStartWithClause || this.hasConnectByClause || this.hasOrderSiblingsByClause || this.hasAsOfClause;
                }
            } else if (this.afterIdentifier == "START WITH") {
                if (this.beforeIdentifier == "ORDER SIBLINGS BY") {
                    return this.hasConnectByClause;
                }
                if (this.beforeIdentifier == "AS OF") {
                    return this.hasConnectByClause || this.hasOrderSiblingsByClause;
                }
                if (this.beforeIdentifier == "WHERE") {
                    return this.hasConnectByClause || this.hasOrderSiblingsByClause || this.hasAsOfClause;
                }
            } else if (this.afterIdentifier == "CONNECT BY") {
                if (this.beforeIdentifier == "AS OF") {
                    return this.hasOrderSiblingsByClause;
                }
                if (this.beforeIdentifier == "WHERE") {
                    return this.hasOrderSiblingsByClause || this.hasAsOfClause;
                }
            } else if (this.afterIdentifier == "ORDER SIBLINGS BY" && this.beforeIdentifier == "WHERE") {
                return this.hasAsOfClause;
            }
            return false;
        }

        public void visit(FromClause expression) {
            if (!this.introspect) {
                super.visit(expression);
            } else {
                this.hasAsOfClause = expression.hasAsOfClause();
                if (expression.hasHierarchicalQueryClause()) {
                    expression.getHierarchicalQueryClause().accept(this);
                }
            }
        }

        public void visit(HierarchicalQueryClause expression) {
            if (!this.introspect) {
                super.visit(expression);
            } else {
                this.hasConnectByClause = expression.hasConnectByClause();
                this.hasStartWithClause = expression.hasStartWithClause();
                this.hasOrderSiblingsByClause = expression.hasOrderSiblingsByClause();
            }
        }

        public void visit(SimpleFromClause expression) {
            if (!this.introspect) {
                super.visit(expression);
            } else {
                this.hasAsOfClause = expression.hasAsOfClause();
                if (expression.hasHierarchicalQueryClause()) {
                    expression.getHierarchicalQueryClause().accept(this);
                }
            }
        }
    }

    protected class FromClauseCollectionHelper
    extends AbstractContentAssistVisitor.FromClauseCollectionHelper {
        protected FromClauseCollectionHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void addAtTheEndOfChild(AbstractFromClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            boolean end;
            super.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, virtualSpace);
            boolean bl = end = index + 1 == collectionExpression.childrenSize();
            if ((index == 0 || hasComma) && end && virtualSpace) {
                if (EclipseLinkContentAssistVisitor.this.isComplete(collectionExpression.getChild(0))) {
                    EclipseLinkContentAssistVisitor.this.addIdentifier("START WITH");
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "CONNECT BY")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
                    }
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "ORDER SIBLINGS BY")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
                    }
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "AS OF")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("AS OF");
                    }
                }
            } else if (index > 0 && end && !hasComma) {
                EclipseLinkContentAssistVisitor.this.queryPosition.getPosition();
                EclipseLinkContentAssistVisitor.this.addCompositeIdentifier("START WITH", 4);
                if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "CONNECT BY")) {
                    EclipseLinkContentAssistVisitor.this.addCompositeIdentifier("CONNECT BY", 6);
                }
                if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "ORDER SIBLINGS BY")) {
                    EclipseLinkContentAssistVisitor.this.addCompositeIdentifier("ORDER SIBLINGS BY", 4);
                }
                if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "AS OF")) {
                    EclipseLinkContentAssistVisitor.this.addCompositeIdentifier("AS OF", 1);
                }
            }
        }

        public void addTheBeginningOfChild(AbstractFromClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            super.addTheBeginningOfChild(expression, collectionExpression, index, hasComma);
            if (index == 0 || hasComma) {
                EclipseLinkContentAssistVisitor.this.proposals.setClassNamePrefix(EclipseLinkContentAssistVisitor.this.word, ContentAssistProposals.ClassType.INSTANTIABLE);
            }
            if (index > 0 && hasComma) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("TABLE");
            }
            if (collectionExpression != null) {
                boolean end;
                boolean bl = end = index + 1 == collectionExpression.childrenSize();
                if (end && !hasComma) {
                    EclipseLinkContentAssistVisitor.this.addIdentifier("START WITH");
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "CONNECT BY")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
                    }
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "ORDER SIBLINGS BY")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
                    }
                    if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "AS OF")) {
                        EclipseLinkContentAssistVisitor.this.addIdentifier("AS OF");
                    }
                }
            }
        }
    }

    protected class FromClauseStatementHelper
    extends AbstractContentAssistVisitor.FromClauseStatementHelper {
        protected FromClauseStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void addInternalClauseProposals(SelectStatement expression) {
            super.addInternalClauseProposals(expression);
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "WHERE")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("START WITH");
            }
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "START WITH", "ORDER SIBLINGS BY")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
            }
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "CONNECT BY", "AS OF")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("ORDER SIBLINGS BY");
            }
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "ORDER SIBLINGS BY", "WHERE")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("AS OF");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IncompleteCollectionExpressionVisitor
    extends AbstractContentAssistVisitor.IncompleteCollectionExpressionVisitor {
        protected IncompleteCollectionExpressionVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        @Override
        protected List<String> compositeIdentifiersAfter(String clause) {
            if (clause == "FROM" && EclipseLinkContentAssistVisitor.this.getEcliseLinkVersion().isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_5)) {
                List<String> identifiers = super.compositeIdentifiersAfter(clause);
                identifiers.add("START WITH");
                identifiers.add("CONNECT BY");
                identifiers.add("ORDER SIBLINGS BY");
                identifiers.add("AS OF");
                return identifiers;
            }
            return super.compositeIdentifiersAfter(clause);
        }
    }

    protected class OrderByClauseStatementHelper
    extends AbstractContentAssistVisitor.OrderByClauseStatementHelper {
        protected OrderByClauseStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public UnionClauseStatementHelper getNextHelper() {
            return EclipseLinkContentAssistVisitor.this.getUnionClauseStatementHelper();
        }

        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }
    }

    protected class SimpleFromClauseStatementHelper
    extends AbstractContentAssistVisitor.SimpleFromClauseStatementHelper {
        protected SimpleFromClauseStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void addInternalClauseProposals(SimpleSelectStatement expression) {
            super.addInternalClauseProposals(expression);
            EclipseLinkContentAssistVisitor.this.addIdentifier("START WITH");
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "CONNECT BY")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
            }
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "ORDER SIBLINGS BY")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("CONNECT BY");
            }
            if (!EclipseLinkContentAssistVisitor.this.hasClausesDefinedBetween(expression, "FROM", "AS OF")) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("AS OF");
            }
        }
    }

    protected class TableExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        protected Expression expression;
        protected boolean valid;

        protected TableExpressionVisitor() {
        }

        public void visit(TableExpression expression) {
            this.valid = this.expression == expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnionClauseStatementHelper
    implements AbstractContentAssistVisitor.StatementHelper<SelectStatement> {
        protected UnionClauseStatementHelper() {
        }

        @Override
        public void addClauseProposals() {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public void addInternalClauseProposals(SelectStatement expression) {
        }

        @Override
        public Expression getClause(SelectStatement expression) {
            return expression.getUnionClauses();
        }

        @Override
        public AbstractContentAssistVisitor.StatementHelper<? extends SelectStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasUnionClauses();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseComplete(SelectStatement expression) {
            return EclipseLinkContentAssistVisitor.this.isComplete(expression.getUnionClauses());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }
}

