/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.mappings;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_OneToMany {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class simpleTypeA = dcl.createDynamicClass("simple.mappings.SimpleA");
        Class simpleTypeB = dcl.createDynamicClass("simple.mappings.SimpleB");
        DynamicTypeBuilder aTypeBuilder = new DynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aTypeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        DynamicTypeBuilder bTypeBuilder = new DynamicTypeBuilder(simpleTypeB, null, new String[]{"SIMPLE_TYPE_B"});
        bTypeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        bTypeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        bTypeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        bTypeBuilder.addOneToOneMapping("a", aTypeBuilder.getType(), new String[]{"A_FK"});
        aTypeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        aTypeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        aTypeBuilder.addOneToManyMapping("b", bTypeBuilder.getType(), new String[]{"A_FK"});
        dynamicHelper.addTypes(true, true, new DynamicType[]{aTypeBuilder.getType(), bTypeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_A");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDynamicTables() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_A");
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_id = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)b_id.getAttributeClassification());
        DirectToFieldMapping b_value1 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)b_value1.getAttributeClassification());
        OneToManyMapping a_b = (OneToManyMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertEquals((Object)descriptorB, (Object)a_b.getReferenceDescriptor());
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        session.release();
    }

    @Test
    public void createSimpleB() {
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        DynamicEntity simpleInstance = simpleTypeB.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"B1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void createAwithB() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        Assert.assertNotNull((Object)session.getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("id", (Object)1);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)1);
        simpleInstanceA.set("value1", (Object)"A2");
        ((Collection)simpleInstanceA.get("b")).add(simpleInstanceB);
        simpleInstanceB.set("a", (Object)simpleInstanceA);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstanceB);
        uow.registerNewObject((Object)simpleInstanceA);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCountB = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountB);
        countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCountA = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
        session.release();
    }

    @Test
    public void removeAwithB_PrivateOwned() {
        this.createAwithB();
        DynamicType simpleAType = dynamicHelper.getType("SimpleA");
        ((OneToManyMapping)simpleAType.getDescriptor().getMappingForAttributeName("b")).setIsPrivateOwned(true);
        UnitOfWork uow = session.acquireUnitOfWork();
        ReadObjectQuery findQuery = dynamicHelper.newReadObjectQuery("SimpleA");
        findQuery.setSelectionCriteria(findQuery.getExpressionBuilder().get("id").equal(1));
        DynamicEntity a = (DynamicEntity)uow.executeQuery((DatabaseQuery)findQuery);
        Assert.assertNotNull((Object)a);
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCountB = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountB);
        countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCountA = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
        uow.deleteObject((Object)a);
        uow.commit();
        countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        simpleCountB = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)0L, (long)simpleCountB);
        countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        simpleCountA = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)0L, (long)simpleCountA);
    }

    @Test
    public void verifyNewSimpleA() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        Assert.assertNotNull((Object)newA);
        Assert.assertEquals((Object)newA.get("id"), (Object)0);
        Assert.assertFalse((boolean)newA.isSet("value1"));
        Assert.assertEquals(Vector.class, newA.get("b").getClass());
        Object b = newA.get("b");
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)(b instanceof Collection));
    }

    @Test(expected=DynamicException.class)
    public void verifyNewSimpleA_InvalidB_Map() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        newA.set("b", new HashMap());
    }

    @Test(expected=DynamicException.class)
    public void verifyNewSimpleA_InvalidB_Object() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        newA.set("b", new Object());
    }

    @Test(expected=DynamicException.class)
    public void verifyNewSimpleA_InvalidB_A() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        newA.set("b", (Object)dynamicHelper.getType("SimpleA").newDynamicEntity());
    }

    @Test(expected=DynamicException.class)
    public void verifyNewSimpleA_InvalidB_B() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        newA.set("b", (Object)dynamicHelper.getType("SimpleB").newDynamicEntity());
    }

    @Test(expected=DynamicException.class)
    public void verifyNewSimpleA_InvalidB_NULL() throws Exception {
        DynamicEntity newA = dynamicHelper.getType("SimpleA").newDynamicEntity();
        newA.set("b", null);
    }

    @Test
    public void createAwithExistingB() {
    }

    @Test
    public void removeBfromA() {
    }

    @Test
    public void addAtoB() {
    }
}

