/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.failover;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedConnection;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedDriver;

public class FullDatabaseFailureTest
extends TestCase {
    protected ServerSession session;

    protected void setup() {
        if (this.getSession().getPlatform().isSymfoware()) {
            this.throwWarning("Test FullDatabaseFailureTest is not supported on Symfoware, failover has not been implemented on this platform. (bug 304908)");
        }
        Project project = this.getSession().getProject().clone();
        DatabaseLogin login = (DatabaseLogin)project.getLogin().clone();
        login.useDirectDriverConnect();
        login.setDriverClass(EmulatedDriver.class);
        login.setConnectionString("jdbc:emulateddriver");
        project.setLogin(login);
        this.session = (ServerSession)project.createServerSession();
        this.session.setSessionLog(this.getSession().getSessionLog());
        this.session.login();
        String sql = this.getSession().getPlatform().getPingSQL();
        Vector rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)this.session.getAccessor().getConnection()).putRows(sql, rows);
        ReadObjectQuery query = new ReadObjectQuery(Address.class);
        this.getSession().executeQuery((DatabaseQuery)query);
        sql = query.getSQLString();
        rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)this.session.getAccessor().getConnection()).putRows(sql, rows);
        List list = this.session.getReadConnectionPool().getConnectionsAvailable();
        for (int i = 0; i < list.size(); ++i) {
            ((EmulatedConnection)((DatabaseAccessor)list.get(i)).getConnection()).causeCommError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        try {
            EmulatedDriver.fullFailure = true;
            this.session.acquireClientSession().readObject(Address.class);
        }
        catch (DatabaseException ex) {
            return;
        }
        finally {
            EmulatedDriver.fullFailure = false;
        }
        throw new TestErrorException("Should have thrown exception as database connection is unavailable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }
}

