/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class RownumFilteringQueryTest
extends TestCase {
    protected QuerySQLTracker tracker = null;
    protected int resultSize;
    protected int maxRows;
    protected int firstResult;
    protected int expectedResultSize;
    protected String queryString = null;
    protected ReadQuery queryToUse;

    public RownumFilteringQueryTest() {
        this.firstResult = 1;
        this.maxRows = 2;
        this.expectedResultSize = 1;
    }

    public RownumFilteringQueryTest(Class classToQuery) {
        this();
        this.queryToUse = new ReadAllQuery(classToQuery);
    }

    public RownumFilteringQueryTest(int maxRows, int firstResult, int expectedResultSize) {
        this.firstResult = firstResult;
        this.maxRows = maxRows;
        this.expectedResultSize = expectedResultSize;
    }

    public void setup() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        DatabasePlatform platform = this.getSession().getPlatform();
        if (!platform.isOracle()) {
            throw new TestWarningException("Oracle Pagination not supported on platform " + platform);
        }
        this.tracker = new QuerySQLTracker((Session)session);
    }

    public void reset() {
        this.tracker.remove();
        this.queryString = null;
    }

    public void test() {
        this.queryString = null;
        this.resultSize = 0;
        ReadQuery query = (ReadQuery)this.getQuery().clone();
        query.setMaxRows(this.maxRows);
        query.setFirstResult(this.firstResult);
        this.resultSize = ((Vector)this.getSession().executeQuery((DatabaseQuery)query)).size();
        List alist = this.tracker.getSqlStatements();
        int size = alist.size();
        if (size > 0) {
            this.queryString = (String)alist.get(size - 1);
        }
    }

    public void verify() {
        if (this.resultSize != this.expectedResultSize) {
            throw new TestErrorException("A ReadAllQuery with MaxRows=" + this.maxRows + ",FirstResult=" + this.firstResult + " returned " + this.resultSize + " result(s) when " + this.expectedResultSize + " result(s) were expected.");
        }
        if (this.queryString == null) {
            throw new TestErrorException("A ReadAllQuery with MaxRows=" + this.maxRows + ",FirstResult=" + this.firstResult + " did not generate an SQL string.");
        }
        int firstSelectIndex = this.queryString.indexOf("SELECT");
        int lastSelectIndex = this.queryString.lastIndexOf("SELECT");
        int firstRowNumIndex = this.queryString.indexOf("ROWNUM");
        int LastRowNumIndex = this.queryString.lastIndexOf("ROWNUM");
        if (firstSelectIndex == lastSelectIndex || firstRowNumIndex == LastRowNumIndex) {
            throw new TestErrorException("A ReadAllQuery with MaxRows=" + this.maxRows + ",FirstResult=" + this.firstResult + " did not generate proper SQL string Using Oracle pagination feature.");
        }
    }

    public ReadQuery getQuery() {
        if (this.queryToUse == null) {
            this.queryToUse = new ReadAllQuery(Employee.class);
        }
        return this.queryToUse;
    }

    public void getQuery(ReadQuery queryToUse) {
        this.queryToUse = queryToUse;
    }
}

