/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NoSuchMethodWhileConstructorInstantiationOfFactoryTest
extends ExceptionTest {
    RelationalDescriptor descriptor;
    InstantiationPolicy policy;
    IntegrityChecker orgIntegrityChecker;

    public NoSuchMethodWhileConstructorInstantiationOfFactoryTest() {
        this.setDescription("This tests No Such Method While Constructor Instantiation Of Factory (TL-ERROR 172)");
    }

    protected void setup() {
        this.descriptor = new RelationalDescriptor();
        this.descriptor.setJavaClass(ExceptionTest.class);
        this.descriptor.addTableName("EMPLOYEE");
        this.policy = this.descriptor.getInstantiationPolicy();
        this.policy.setMethodName("invalidMethod");
        this.policy.useFactoryInstantiationPolicy(ExceptionTest.class, "invalidMethod");
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
        this.expectedException = DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory((ClassDescriptor)this.descriptor, (Throwable)new Exception());
    }

    @Override
    public void reset() {
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.policy.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

