/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inherited;

import java.util.Date;
import java.util.Vector;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.inherited.SerialNumber;

public class OrderedListJunitTest
extends JUnitTestCase {
    private static Integer m_beerConsumerId;

    public OrderedListJunitTest() {
    }

    public OrderedListJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("OrderedListJunitTest");
        suite.addTest((Test)new OrderedListJunitTest("testSetup"));
        suite.addTest((Test)new OrderedListJunitTest("testInitialize"));
        suite.addTest((Test)new OrderedListJunitTest("test1"));
        suite.addTest((Test)new OrderedListJunitTest("testInitialize"));
        suite.addTest((Test)new OrderedListJunitTest("test2"));
        suite.addTest((Test)new OrderedListJunitTest("testInitialize"));
        suite.addTest((Test)new OrderedListJunitTest("test3"));
        return suite;
    }

    public void testSetup() {
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testInitialize() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = new BeerConsumer();
            beerConsumer.setName("Guy Pelletier");
            em.persist((Object)beerConsumer);
            m_beerConsumerId = beerConsumer.getId();
            SerialNumber serialNumber1 = new SerialNumber();
            em.persist((Object)serialNumber1);
            Alpine alpine1 = new Alpine(serialNumber1);
            em.persist((Object)alpine1);
            alpine1.setBestBeforeDate(new Date(2005, 8, 17));
            alpine1.setAlcoholContent((Object)5.0);
            alpine1.setClassification(Alpine.Classification.STRONG);
            beerConsumer.addAlpineBeerToConsume(alpine1);
            SerialNumber serialNumber2 = new SerialNumber();
            em.persist((Object)serialNumber2);
            Alpine alpine2 = new Alpine(serialNumber2);
            em.persist((Object)alpine2);
            alpine2.setBestBeforeDate(new Date(2005, 8, 19));
            alpine2.setAlcoholContent((Object)4.0);
            alpine2.setClassification(Alpine.Classification.STRONG);
            beerConsumer.addAlpineBeerToConsume(alpine2);
            SerialNumber serialNumber3 = new SerialNumber();
            em.persist((Object)serialNumber3);
            Alpine alpine3 = new Alpine(serialNumber3);
            em.persist((Object)alpine3);
            alpine3.setBestBeforeDate(new Date(2005, 8, 21));
            alpine3.setAlcoholContent((Object)3.0);
            alpine3.setClassification(Alpine.Classification.STRONG);
            beerConsumer.addAlpineBeerToConsume(alpine3);
            SerialNumber serialNumber4 = new SerialNumber();
            em.persist((Object)serialNumber4);
            Alpine alpine4 = new Alpine(serialNumber4);
            em.persist((Object)alpine4);
            alpine4.setBestBeforeDate(new Date(2005, 8, 23));
            alpine4.setAlcoholContent((Object)2.0);
            alpine4.setClassification(Alpine.Classification.BITTER);
            beerConsumer.addAlpineBeerToConsume(alpine4);
            SerialNumber serialNumber5 = new SerialNumber();
            em.persist((Object)serialNumber5);
            Alpine alpine5 = new Alpine(serialNumber5);
            em.persist((Object)alpine5);
            alpine5.setBestBeforeDate(new Date(2005, 8, 25));
            alpine5.setAlcoholContent((Object)1.0);
            alpine5.setClassification(Alpine.Classification.SWEET);
            beerConsumer.addAlpineBeerToConsume(alpine5);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            OrderedListJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
    }

    public void test1() {
        BeerConsumer beerConsumer = null;
        Alpine alpine1 = null;
        Alpine alpine2 = null;
        EntityManager em = this.createEntityManager();
        try {
            beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
            this.beginTransaction(em);
            beerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            alpine1 = beerConsumer.removeAlpineBeerToConsume(1);
            alpine2 = beerConsumer.removeAlpineBeerToConsume(1);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            OrderedListJunitTest.fail((String)("An exception was caught during test1 : [" + ex.getMessage() + "]"));
        }
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        Vector alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Incorrect number of alpines in the list", (alpinesFromCache.size() == 3 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"Alpine 1 was not removed from the list", (boolean)alpinesFromCache.contains(alpine1));
        OrderedListJunitTest.assertFalse((String)"Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Shared cache: Incorrect number of alpines in the list", (alpinesFromCache.size() == 3 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"Shared cache: Alpine 1 was not removed from the list", (boolean)alpinesFromCache.contains(alpine1));
        OrderedListJunitTest.assertFalse((String)"Shared cache: Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
        this.clearCache();
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"database: Incorrect number of alpines in the list", (alpinesFromCache.size() == 3 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"database: Alpine 1 was not removed from the list", (boolean)alpinesFromCache.contains(alpine1));
        OrderedListJunitTest.assertFalse((String)"database: Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
    }

    public void test2() {
        BeerConsumer beerConsumer = null;
        Alpine alpine1 = null;
        Alpine alpine2 = null;
        EntityManager em = this.createEntityManager();
        try {
            beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
            this.beginTransaction(em);
            beerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            alpine1 = beerConsumer.moveAlpineBeerToConsume(2, 4);
            alpine2 = beerConsumer.moveAlpineBeerToConsume(1, 3);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            OrderedListJunitTest.fail((String)("An exception was caught while adding the new alpine at a specific index: [" + ex.getMessage() + "]"));
        }
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        Vector alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 4 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Alpine 2 was not at the correct index.", (alpinesFromCache.indexOf(alpine2) == 3 ? 1 : 0) != 0);
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Shared cache: Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Shared cache: Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 4 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Shared cache: Alpine 2 was not at the correct index.", (alpinesFromCache.indexOf(alpine2) == 3 ? 1 : 0) != 0);
        this.clearCache();
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"database: Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"database: Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 2 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"database: Alpine 2 was not at the correct index.", (alpinesFromCache.indexOf(alpine2) == 1 ? 1 : 0) != 0);
    }

    public void test3() {
        BeerConsumer beerConsumer = null;
        Alpine alpine1 = null;
        Alpine alpine2 = null;
        Alpine alpine3 = null;
        Alpine alpine4 = null;
        EntityManager em = this.createEntityManager();
        try {
            beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
            this.beginTransaction(em);
            beerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            alpine1 = beerConsumer.moveAlpineBeerToConsume(4, 1);
            alpine2 = beerConsumer.removeAlpineBeerToConsume(0);
            alpine3 = beerConsumer.moveAlpineBeerToConsume(1, 3);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            alpine4 = new Alpine(serialNumber);
            em.persist((Object)alpine4);
            alpine4.setBestBeforeDate(new Date(2005, 8, 29));
            alpine4.setAlcoholContent((Object)7.0);
            alpine4.setClassification(Alpine.Classification.SWEET);
            beerConsumer.addAlpineBeerToConsume(alpine4, 3);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            OrderedListJunitTest.fail((String)("An exception was caught while adding the new alpine at a specific index: [" + ex.getMessage() + "]"));
        }
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        Vector alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 0 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
        OrderedListJunitTest.assertTrue((String)"Alpine 3 was not at the correct index.", (alpinesFromCache.indexOf(alpine3) == 4 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Alpine 4 was not at the correct index.", (alpinesFromCache.indexOf(alpine4) == 3 ? 1 : 0) != 0);
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"Shared cache: Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Shared cache: Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 0 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"Shared cache: Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
        OrderedListJunitTest.assertTrue((String)"Shared cache: Alpine 3 was not at the correct index.", (alpinesFromCache.indexOf(alpine3) == 4 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"Shared cache: Alpine 4 was not at the correct index.", (alpinesFromCache.indexOf(alpine4) == 3 ? 1 : 0) != 0);
        this.clearCache();
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
        alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        OrderedListJunitTest.assertTrue((String)"database: Incorrect number of alpines in the list", (alpinesFromCache.size() == 5 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"database: Alpine 1 was not at the correct index.", (alpinesFromCache.indexOf(alpine1) == 3 ? 1 : 0) != 0);
        OrderedListJunitTest.assertFalse((String)"database: Alpine 2 was not removed from the list", (boolean)alpinesFromCache.contains(alpine2));
        OrderedListJunitTest.assertTrue((String)"database: Alpine 3 was not at the correct index.", (alpinesFromCache.indexOf(alpine3) == 0 ? 1 : 0) != 0);
        OrderedListJunitTest.assertTrue((String)"database: Alpine 4 was not at the correct index.", (alpinesFromCache.indexOf(alpine4) == 4 ? 1 : 0) != 0);
    }
}

