/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.Range;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class RangeTests
extends TestCase {
    public RangeTests(String name) {
        super(name);
    }

    public void testIncludes() {
        Range range = new Range(5, 17);
        RangeTests.assertFalse((boolean)range.includes(-55));
        RangeTests.assertFalse((boolean)range.includes(0));
        RangeTests.assertFalse((boolean)range.includes(4));
        RangeTests.assertTrue((boolean)range.includes(5));
        RangeTests.assertTrue((boolean)range.includes(6));
        RangeTests.assertTrue((boolean)range.includes(16));
        RangeTests.assertTrue((boolean)range.includes(17));
        RangeTests.assertFalse((boolean)range.includes(18));
        RangeTests.assertFalse((boolean)range.includes(200));
    }

    public void testEquals() {
        Range range1 = new Range(5, 17);
        Range range2 = new Range(5, 17);
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
        range2 = new Range(17, 5);
        RangeTests.assertFalse((boolean)range1.equals((Object)range2));
        RangeTests.assertFalse((boolean)range2.equals((Object)range1));
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
        range2 = new Range(5, 15);
        RangeTests.assertFalse((boolean)range1.equals((Object)range2));
        RangeTests.assertFalse((boolean)range2.equals((Object)range1));
    }

    public void testClone() {
        Range range1 = new Range(5, 17);
        Range range2 = range1.clone();
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
    }

    public void testSerialization() throws Exception {
        Range range1 = new Range(5, 17);
        Range range2 = TestTools.serialize(range1);
        RangeTests.assertNotSame((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range1, (Object)range1);
        RangeTests.assertEquals((Object)range1, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range1);
        RangeTests.assertEquals((int)range1.hashCode(), (int)range2.hashCode());
    }
}

