/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class CollectionTable
extends Table
implements ExternalCollectionTable {
    static final String COLLECTION_TABLE = "collection-table";

    CollectionTable(BasicCollectionMapping parent) {
        super(parent);
    }

    CollectionTable(BasicMapMapping parent) {
        super(parent);
    }

    CollectionTable(ElementCollectionMapping parent) {
        super(parent);
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("catalog");
        names.add("schema");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("unique-constraint");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    @Override
    protected String getElementName() {
        return COLLECTION_TABLE;
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(index);
    }

    @Override
    public boolean isDefault() {
        return !this.hasChildren() && !this.hasAttributes();
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }
}

