/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalConversionValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.ConversionValue;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class ObjectTypeConverter
extends AbstractExternalForm
implements ExternalObjectTypeConverter {
    private int index;
    static final String DATA_TYPE = "data-type";
    static final String DEFAULT_OBJECT_VALUE = "default-object-value";
    static final String NAME = "name";
    static final String OBJECT_TYPE = "object-type";
    static final String OBJECT_TYPE_CONVERTER = "object-type-converter";

    ObjectTypeConverter(AbstractExternalForm parent) {
        super(parent);
        this.index = -1;
    }

    ObjectTypeConverter(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalConversionValue addConversionValue(int index) {
        ConversionValue conversionValue = this.buildConversionValue(index);
        conversionValue.addSelf();
        return conversionValue;
    }

    @Override
    protected Element addSelf(String elementName) {
        if (this.index == -1) {
            return super.addSelf(elementName);
        }
        return this.addChild(this.getParent(), elementName, this.index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(NAME);
        names.add(DATA_TYPE);
        names.add(OBJECT_TYPE);
        return names;
    }

    private ConversionValue buildConversionValue(int index) {
        return new ConversionValue(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("conversion-value");
        names.add(DEFAULT_OBJECT_VALUE);
        return names;
    }

    @Override
    public ListIterable<ExternalConversionValue> conversionValues() {
        int count = this.conversionValuesSize();
        ArrayList<ConversionValue> conversionValues = new ArrayList<ConversionValue>(count);
        int index = count;
        while (--index >= 0) {
            ConversionValue column = this.buildConversionValue(index);
            conversionValues.add(0, column);
        }
        return new ListListIterable(conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.getChildrenSize("conversion-value");
    }

    @Override
    public ExternalConversionValue getConversionValue(int index) {
        Element element = this.getChild("conversion-value", index);
        if (element == null) {
            return null;
        }
        return this.buildConversionValue(index);
    }

    @Override
    public String getDatatype() {
        return this.getAttribute(DATA_TYPE);
    }

    @Override
    public String getDefaultValue() {
        return this.getChildTextNode(DEFAULT_OBJECT_VALUE);
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return OBJECT_TYPE_CONVERTER;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public String getObjecttype() {
        return this.getAttribute(OBJECT_TYPE);
    }

    @Override
    public void removeAllConversionValue() {
        this.removeChildren("conversion-value");
    }

    @Override
    public void removeConversionValue(int index) {
        ConversionValue conversionValue = this.buildConversionValue(index);
        conversionValue.removeSelf();
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public void setDatatype(String datatypeName) {
        this.setAttribute(DATA_TYPE, datatypeName);
    }

    @Override
    public void setDefaultValue(String value) {
        this.updateChildTextNode(DEFAULT_OBJECT_VALUE, value);
    }

    @Override
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    @Override
    public void setObjecttype(String objecttypeName) {
        this.setAttribute(OBJECT_TYPE, objecttypeName);
    }
}

