/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class OneToOneMapping
extends RelationshipMapping
implements ExternalOneToOneMapping {
    static final String ID = "id";
    static final String MAPPED_BY = "mapped-by";
    static final String MAPS_ID = "maps-id";
    static final String ONE_TO_ONE = "one-to-one";
    static final String ORPHAN_REMOVAL = "orphan-removal";
    static final String PRIVATE_OWNED = "private-owned";

    OneToOneMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addJoinField(int index, String name) {
        ExternalNoSqlJoinField joinField = this.buildJoinField(index);
        joinField.setName(name);
    }

    @Override
    public void addPrimaryKeyJoinColumn(int index, String name) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.addSelf();
        pkJoinColumn.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add(MAPPED_BY);
        names.add(ORPHAN_REMOVAL);
        names.add(MAPS_ID);
        names.add(ID);
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("primary-key-join-column");
        names.add("join-column");
        names.add("join-table");
        names.add("cascade");
        names.add(PRIVATE_OWNED);
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    private ExternalNoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    @Override
    protected String getElementName() {
        return ONE_TO_ONE;
    }

    @Override
    public Boolean getId() {
        return this.getBooleanAttribute(ID);
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(index);
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute(MAPPED_BY);
    }

    @Override
    public String getMapsId() {
        return this.getAttribute(MAPS_ID);
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        Element element = this.getChild("primary-key-join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildPrimaryKeyJoinColumn(index);
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute(ORPHAN_REMOVAL);
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild(PRIVATE_OWNED);
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public ListIterable<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = count;
        while (--index >= 0) {
            ExternalNoSqlJoinField joinField = this.buildJoinField(index);
            joinFields.add(0, joinField);
        }
        return new ListListIterable(joinFields);
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public ListIterable<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<PrimaryKeyJoinColumn> pkJoinColumns = new ArrayList<PrimaryKeyJoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
            pkJoinColumns.add(0, pkJoinColumn);
        }
        return new ListListIterable(pkJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void setId(Boolean id) {
        this.setAttribute(ID, id);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute(MAPPED_BY, name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute(MAPS_ID, mapsId);
    }

    @Override
    public void setOrphanRemoval(Boolean removeOrphans) {
        this.setAttribute(ORPHAN_REMOVAL, removeOrphans);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild(PRIVATE_OWNED);
        } else {
            this.removeChild(PRIVATE_OWNED);
        }
    }
}

