/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.w3c.dom.Element;

abstract class PrimaryKeyGenerator
extends AbstractExternalForm
implements ExternalPrimaryKeyGenerator {
    private int index;
    static final String ALLOCATION_SIZE = "allocation-size";
    static final String CATALOG = "catalog";
    static final String DESCRIPTION = "description";
    static final String INITIAL_VALUE = "initial-value";
    static final String NAME = "name";
    static final String SCHEMA = "schema";

    PrimaryKeyGenerator(AbstractExternalForm parent) {
        super(parent);
        this.index = -1;
    }

    PrimaryKeyGenerator(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected final Element addSelf(String elementName, List<String> elementNamesOrder) {
        if (this.index == -1) {
            return super.addSelf(elementName, elementNamesOrder);
        }
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        return names;
    }

    @Override
    public final Integer getAllocationSize() {
        return this.getIntegerAttribute(ALLOCATION_SIZE);
    }

    @Override
    public final String getCatalogName() {
        return this.getAttribute(CATALOG);
    }

    @Override
    public final String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public final Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final Integer getInitialValue() {
        return this.getIntegerAttribute(INITIAL_VALUE);
    }

    @Override
    public final String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public final String getSchemaName() {
        return this.getAttribute(SCHEMA);
    }

    @Override
    public final void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public final void setAllocationSize(Integer size) {
        this.setAttribute(ALLOCATION_SIZE, size);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setCatalogName(String name) {
        this.setAttribute(CATALOG, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public final void setInitialValue(Integer size) {
        this.setAttribute(INITIAL_VALUE, size);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setName(String name) {
        this.setAttribute(NAME, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setSchemaName(String name) {
        this.setAttribute(SCHEMA, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    final boolean shouldBeRemoved() {
        return this.index == -1 && !this.hasAnyChildren() && !this.hasAttributes();
    }
}

