/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntitySecondaryTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class SecondaryTable
extends Table
implements ExternalEntitySecondaryTable {
    private int index;
    static final String SECONDARY_TABLE = "secondary-table";

    SecondaryTable(Entity parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public void addPrimaryKeyJoinColumn(int index, String name) {
        PrimaryKeyJoinColumn primaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        primaryKeyJoinColumn.addSelf();
        primaryKeyJoinColumn.setName(name);
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        if (this.index == -1) {
            return super.addSelf(elementName, elementNamesOrder);
        }
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("primary-key-join-column");
        names.add("unique-constraint");
        return names;
    }

    private PrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(int index) {
        return new PrimaryKeyJoinColumn(this, index);
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return SECONDARY_TABLE;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index) {
        Element element = this.getChild("primary-key-join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildPrimaryKeyJoinColumn(index);
    }

    @Override
    public ListIterable<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        int count = this.primaryKeyJoinColumnsSize();
        ArrayList<PrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(index);
            primaryKeyJoinColumns.add(0, primaryKeyJoinColumn);
        }
        return new ListListIterable(primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.getChildrenSize("primary-key-join-column");
    }

    @Override
    public void removeAllPrimaryKeyJoinColumns() {
        this.removeChildren("primary-key-join-column");
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumn pkJoinColumn = this.buildPrimaryKeyJoinColumn(index);
        pkJoinColumn.removeSelf();
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }
}

